<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Artwork StructType
 * Meta information extracted from the WSDL
 * - documentation: An array of typeset data | An object that explains how the artwork layers or stops will be handled | The dimensions of the artwork | An array of artwork file data
 * @subpackage Structs
 */
class Artwork extends AbstractStructBase
{
    /**
     * The instructions
     * Meta information extracted from the WSDL
     * - documentation: Any instructions regarding the processing or modification of artwork. Adding instructions will cause delays in processing.
     * - minOccurs: 0
     * @var string
     */
    public $instructions;
    /**
     * The refArtworkId
     * Meta information extracted from the WSDL
     * - documentation: A pre-shared artwork Id that can be used by the supplier to find and reference the artwork.
     * - base: xsd:string
     * - maxLength: 64
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $refArtworkId;
    /**
     * The totalStitchCount
     * Meta information extracted from the WSDL
     * - documentation: The total stitch count for the specified embroidery art
     * - minOccurs: 0
     * @var int
     */
    public $totalStitchCount;
    /**
     * The ArtworkFileArray
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns2:ArtworkFileArray
     * @var \ArrayType\ArtworkFileArray
     */
    public $ArtworkFileArray;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns2:description
     * @var string
     */
    public $description;
    /**
     * The Dimensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns2:Dimensions
     * @var \StructType\Dimensions
     */
    public $Dimensions;
    /**
     * The Layers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns2:Layers
     * @var \StructType\Layers
     */
    public $Layers;
    /**
     * The TypesetArray
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns2:TypesetArray
     * @var \ArrayType\TypesetArray
     */
    public $TypesetArray;
    /**
     * Constructor method for Artwork
     * @uses Artwork::setInstructions()
     * @uses Artwork::setRefArtworkId()
     * @uses Artwork::setTotalStitchCount()
     * @uses Artwork::setArtworkFileArray()
     * @uses Artwork::setDescription()
     * @uses Artwork::setDimensions()
     * @uses Artwork::setLayers()
     * @uses Artwork::setTypesetArray()
     * @param string $instructions
     * @param string $refArtworkId
     * @param int $totalStitchCount
     * @param \ArrayType\ArtworkFileArray $artworkFileArray
     * @param string $description
     * @param \StructType\Dimensions $dimensions
     * @param \StructType\Layers $layers
     * @param \ArrayType\TypesetArray $typesetArray
     */
    public function __construct($instructions = null, $refArtworkId = null, $totalStitchCount = null, \ArrayType\ArtworkFileArray $artworkFileArray = null, $description = null, \StructType\Dimensions $dimensions = null, \StructType\Layers $layers = null, \ArrayType\TypesetArray $typesetArray = null)
    {
        $this
            ->setInstructions($instructions)
            ->setRefArtworkId($refArtworkId)
            ->setTotalStitchCount($totalStitchCount)
            ->setArtworkFileArray($artworkFileArray)
            ->setDescription($description)
            ->setDimensions($dimensions)
            ->setLayers($layers)
            ->setTypesetArray($typesetArray);
    }
    /**
     * Get instructions value
     * @return string|null
     */
    public function getInstructions()
    {
        return $this->instructions;
    }
    /**
     * Set instructions value
     * @param string $instructions
     * @return \StructType\Artwork
     */
    public function setInstructions($instructions = null)
    {
        // validation for constraint: string
        if (!is_null($instructions) && !is_string($instructions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($instructions, true), gettype($instructions)), __LINE__);
        }
        $this->instructions = $instructions;
        return $this;
    }
    /**
     * Get refArtworkId value
     * @return string|null
     */
    public function getRefArtworkId()
    {
        return $this->refArtworkId;
    }
    /**
     * Set refArtworkId value
     * @param string $refArtworkId
     * @return \StructType\Artwork
     */
    public function setRefArtworkId($refArtworkId = null)
    {
        // validation for constraint: string
        if (!is_null($refArtworkId) && !is_string($refArtworkId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refArtworkId, true), gettype($refArtworkId)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($refArtworkId) && mb_strlen($refArtworkId) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($refArtworkId)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($refArtworkId) && mb_strlen($refArtworkId) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($refArtworkId)), __LINE__);
        }
        $this->refArtworkId = $refArtworkId;
        return $this;
    }
    /**
     * Get totalStitchCount value
     * @return int|null
     */
    public function getTotalStitchCount()
    {
        return $this->totalStitchCount;
    }
    /**
     * Set totalStitchCount value
     * @param int $totalStitchCount
     * @return \StructType\Artwork
     */
    public function setTotalStitchCount($totalStitchCount = null)
    {
        // validation for constraint: int
        if (!is_null($totalStitchCount) && !(is_int($totalStitchCount) || ctype_digit($totalStitchCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalStitchCount, true), gettype($totalStitchCount)), __LINE__);
        }
        $this->totalStitchCount = $totalStitchCount;
        return $this;
    }
    /**
     * Get ArtworkFileArray value
     * @return \ArrayType\ArtworkFileArray|null
     */
    public function getArtworkFileArray()
    {
        return $this->ArtworkFileArray;
    }
    /**
     * Set ArtworkFileArray value
     * @param \ArrayType\ArtworkFileArray $artworkFileArray
     * @return \StructType\Artwork
     */
    public function setArtworkFileArray(\ArrayType\ArtworkFileArray $artworkFileArray = null)
    {
        $this->ArtworkFileArray = $artworkFileArray;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\Artwork
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get Dimensions value
     * @return \StructType\Dimensions|null
     */
    public function getDimensions()
    {
        return $this->Dimensions;
    }
    /**
     * Set Dimensions value
     * @param \StructType\Dimensions $dimensions
     * @return \StructType\Artwork
     */
    public function setDimensions(\StructType\Dimensions $dimensions = null)
    {
        $this->Dimensions = $dimensions;
        return $this;
    }
    /**
     * Get Layers value
     * @return \StructType\Layers|null
     */
    public function getLayers()
    {
        return $this->Layers;
    }
    /**
     * Set Layers value
     * @param \StructType\Layers $layers
     * @return \StructType\Artwork
     */
    public function setLayers(\StructType\Layers $layers = null)
    {
        $this->Layers = $layers;
        return $this;
    }
    /**
     * Get TypesetArray value
     * @return \ArrayType\TypesetArray|null
     */
    public function getTypesetArray()
    {
        return $this->TypesetArray;
    }
    /**
     * Set TypesetArray value
     * @param \ArrayType\TypesetArray $typesetArray
     * @return \StructType\Artwork
     */
    public function setTypesetArray(\ArrayType\TypesetArray $typesetArray = null)
    {
        $this->TypesetArray = $typesetArray;
        return $this;
    }
}
