<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getSupportedOrderTypes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSupportedOrderTypesRequest $getSupportedOrderTypesRequest
     * @return \StructType\GetSupportedOrderTypesResponse|bool
     */
    public function getSupportedOrderTypes(\StructType\GetSupportedOrderTypesRequest $getSupportedOrderTypesRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->getSupportedOrderTypes($getSupportedOrderTypesRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetSupportedOrderTypesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
