<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ISO20022UomCode EnumType
 * Meta information extracted from the WSDL
 * - documentation: https://www.iso20022.org/standardsrepository/public/wqt/Description/mx/dico/codesets/_Y4XF0tp-Ed-ak6NoX_4Aeg_385163498 The type of Dimension UOM
 * @subpackage Enumerations
 */
class ISO20022UomCode extends AbstractStructEnumBase
{
    /**
     * Constant for value 'PIEC'
     * @return string 'PIEC'
     */
    const VALUE_PIEC = 'PIEC';
    /**
     * Constant for value 'TONS'
     * @return string 'TONS'
     */
    const VALUE_TONS = 'TONS';
    /**
     * Constant for value 'FOOT'
     * @return string 'FOOT'
     */
    const VALUE_FOOT = 'FOOT';
    /**
     * Constant for value 'GBGA'
     * @return string 'GBGA'
     */
    const VALUE_GBGA = 'GBGA';
    /**
     * Constant for value 'USGA'
     * @return string 'USGA'
     */
    const VALUE_USGA = 'USGA';
    /**
     * Constant for value 'GRAM'
     * @return string 'GRAM'
     */
    const VALUE_GRAM = 'GRAM';
    /**
     * Constant for value 'INCH'
     * @return string 'INCH'
     */
    const VALUE_INCH = 'INCH';
    /**
     * Constant for value 'KILO'
     * @return string 'KILO'
     */
    const VALUE_KILO = 'KILO';
    /**
     * Constant for value 'PUND'
     * @return string 'PUND'
     */
    const VALUE_PUND = 'PUND';
    /**
     * Constant for value 'METR'
     * @return string 'METR'
     */
    const VALUE_METR = 'METR';
    /**
     * Constant for value 'CMET'
     * @return string 'CMET'
     */
    const VALUE_CMET = 'CMET';
    /**
     * Constant for value 'MMET'
     * @return string 'MMET'
     */
    const VALUE_MMET = 'MMET';
    /**
     * Constant for value 'LITR'
     * @return string 'LITR'
     */
    const VALUE_LITR = 'LITR';
    /**
     * Constant for value 'CELI'
     * @return string 'CELI'
     */
    const VALUE_CELI = 'CELI';
    /**
     * Constant for value 'MILI'
     * @return string 'MILI'
     */
    const VALUE_MILI = 'MILI';
    /**
     * Constant for value 'GBOU'
     * @return string 'GBOU'
     */
    const VALUE_GBOU = 'GBOU';
    /**
     * Constant for value 'USOU'
     * @return string 'USOU'
     */
    const VALUE_USOU = 'USOU';
    /**
     * Constant for value 'GBQA'
     * @return string 'GBQA'
     */
    const VALUE_GBQA = 'GBQA';
    /**
     * Constant for value 'USQA'
     * @return string 'USQA'
     */
    const VALUE_USQA = 'USQA';
    /**
     * Constant for value 'GBPI'
     * @return string 'GBPI'
     */
    const VALUE_GBPI = 'GBPI';
    /**
     * Constant for value 'USPI'
     * @return string 'USPI'
     */
    const VALUE_USPI = 'USPI';
    /**
     * Constant for value 'MILE'
     * @return string 'MILE'
     */
    const VALUE_MILE = 'MILE';
    /**
     * Constant for value 'KMET'
     * @return string 'KMET'
     */
    const VALUE_KMET = 'KMET';
    /**
     * Constant for value 'YARD'
     * @return string 'YARD'
     */
    const VALUE_YARD = 'YARD';
    /**
     * Constant for value 'SQKI'
     * @return string 'SQKI'
     */
    const VALUE_SQKI = 'SQKI';
    /**
     * Constant for value 'HECT'
     * @return string 'HECT'
     */
    const VALUE_HECT = 'HECT';
    /**
     * Constant for value 'ARES'
     * @return string 'ARES'
     */
    const VALUE_ARES = 'ARES';
    /**
     * Constant for value 'SMET'
     * @return string 'SMET'
     */
    const VALUE_SMET = 'SMET';
    /**
     * Constant for value 'SCMT'
     * @return string 'SCMT'
     */
    const VALUE_SCMT = 'SCMT';
    /**
     * Constant for value 'SMIL'
     * @return string 'SMIL'
     */
    const VALUE_SMIL = 'SMIL';
    /**
     * Constant for value 'SQMI'
     * @return string 'SQMI'
     */
    const VALUE_SQMI = 'SQMI';
    /**
     * Constant for value 'SQYA'
     * @return string 'SQYA'
     */
    const VALUE_SQYA = 'SQYA';
    /**
     * Constant for value 'SQFO'
     * @return string 'SQFO'
     */
    const VALUE_SQFO = 'SQFO';
    /**
     * Constant for value 'SQIN'
     * @return string 'SQIN'
     */
    const VALUE_SQIN = 'SQIN';
    /**
     * Constant for value 'ACRE'
     * @return string 'ACRE'
     */
    const VALUE_ACRE = 'ACRE';
    /**
     * Return allowed values
     * @uses self::VALUE_PIEC
     * @uses self::VALUE_TONS
     * @uses self::VALUE_FOOT
     * @uses self::VALUE_GBGA
     * @uses self::VALUE_USGA
     * @uses self::VALUE_GRAM
     * @uses self::VALUE_INCH
     * @uses self::VALUE_KILO
     * @uses self::VALUE_PUND
     * @uses self::VALUE_METR
     * @uses self::VALUE_CMET
     * @uses self::VALUE_MMET
     * @uses self::VALUE_LITR
     * @uses self::VALUE_CELI
     * @uses self::VALUE_MILI
     * @uses self::VALUE_GBOU
     * @uses self::VALUE_USOU
     * @uses self::VALUE_GBQA
     * @uses self::VALUE_USQA
     * @uses self::VALUE_GBPI
     * @uses self::VALUE_USPI
     * @uses self::VALUE_MILE
     * @uses self::VALUE_KMET
     * @uses self::VALUE_YARD
     * @uses self::VALUE_SQKI
     * @uses self::VALUE_HECT
     * @uses self::VALUE_ARES
     * @uses self::VALUE_SMET
     * @uses self::VALUE_SCMT
     * @uses self::VALUE_SMIL
     * @uses self::VALUE_SQMI
     * @uses self::VALUE_SQYA
     * @uses self::VALUE_SQFO
     * @uses self::VALUE_SQIN
     * @uses self::VALUE_ACRE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PIEC,
            self::VALUE_TONS,
            self::VALUE_FOOT,
            self::VALUE_GBGA,
            self::VALUE_USGA,
            self::VALUE_GRAM,
            self::VALUE_INCH,
            self::VALUE_KILO,
            self::VALUE_PUND,
            self::VALUE_METR,
            self::VALUE_CMET,
            self::VALUE_MMET,
            self::VALUE_LITR,
            self::VALUE_CELI,
            self::VALUE_MILI,
            self::VALUE_GBOU,
            self::VALUE_USOU,
            self::VALUE_GBQA,
            self::VALUE_USQA,
            self::VALUE_GBPI,
            self::VALUE_USPI,
            self::VALUE_MILE,
            self::VALUE_KMET,
            self::VALUE_YARD,
            self::VALUE_SQKI,
            self::VALUE_HECT,
            self::VALUE_ARES,
            self::VALUE_SMET,
            self::VALUE_SCMT,
            self::VALUE_SMIL,
            self::VALUE_SQMI,
            self::VALUE_SQYA,
            self::VALUE_SQFO,
            self::VALUE_SQIN,
            self::VALUE_ACRE,
        );
    }
}
