<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ColorSystemType EnumType
 * Meta information extracted from the WSDL
 * - documentation: The type of color system
 * @subpackage Enumerations
 */
class ColorSystemType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Cmyk'
     * @return string 'Cmyk'
     */
    const VALUE_CMYK = 'Cmyk';
    /**
     * Constant for value 'Other'
     * @return string 'Other'
     */
    const VALUE_OTHER = 'Other';
    /**
     * Constant for value 'Pms'
     * @return string 'Pms'
     */
    const VALUE_PMS = 'Pms';
    /**
     * Constant for value 'Rgb'
     * @return string 'Rgb'
     */
    const VALUE_RGB = 'Rgb';
    /**
     * Constant for value 'Thread'
     * @return string 'Thread'
     */
    const VALUE_THREAD = 'Thread';
    /**
     * Return allowed values
     * @uses self::VALUE_CMYK
     * @uses self::VALUE_OTHER
     * @uses self::VALUE_PMS
     * @uses self::VALUE_RGB
     * @uses self::VALUE_THREAD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CMYK,
            self::VALUE_OTHER,
            self::VALUE_PMS,
            self::VALUE_RGB,
            self::VALUE_THREAD,
        );
    }
}
