<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ArtworkType EnumType
 * Meta information extracted from the WSDL
 * - documentation: The purpose of the artwork file
 * @subpackage Enumerations
 */
class ArtworkType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'NonProductionReady'
     * @return string 'NonProductionReady'
     */
    const VALUE_NON_PRODUCTION_READY = 'NonProductionReady';
    /**
     * Constant for value 'ProductionReady'
     * @return string 'ProductionReady'
     */
    const VALUE_PRODUCTION_READY = 'ProductionReady';
    /**
     * Constant for value 'SupplierArtTemplate'
     * @return string 'SupplierArtTemplate'
     */
    const VALUE_SUPPLIER_ART_TEMPLATE = 'SupplierArtTemplate';
    /**
     * Constant for value 'VirtualProof'
     * @return string 'VirtualProof'
     */
    const VALUE_VIRTUAL_PROOF = 'VirtualProof';
    /**
     * Return allowed values
     * @uses self::VALUE_NON_PRODUCTION_READY
     * @uses self::VALUE_PRODUCTION_READY
     * @uses self::VALUE_SUPPLIER_ART_TEMPLATE
     * @uses self::VALUE_VIRTUAL_PROOF
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NON_PRODUCTION_READY,
            self::VALUE_PRODUCTION_READY,
            self::VALUE_SUPPLIER_ART_TEMPLATE,
            self::VALUE_VIRTUAL_PROOF,
        );
    }
}
