<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for TaxInformationArray ArrayType
 * Meta information extracted from the WSDL
 * - documentation: An array of TaxInformation objects related to calculating taxes
 * @subpackage Arrays
 */
class TaxInformationArray extends AbstractStructArrayBase
{
    /**
     * The TaxInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ns3:TaxInformation
     * @var \StructType\TaxInformation[]
     */
    public $TaxInformation;
    /**
     * Constructor method for TaxInformationArray
     * @uses TaxInformationArray::setTaxInformation()
     * @param \StructType\TaxInformation[] $taxInformation
     */
    public function __construct(array $taxInformation = array())
    {
        $this
            ->setTaxInformation($taxInformation);
    }
    /**
     * Get TaxInformation value
     * @return \StructType\TaxInformation[]|null
     */
    public function getTaxInformation()
    {
        return $this->TaxInformation;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxInformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxInformation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxInformationForArrayConstraintsFromSetTaxInformation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxInformationArrayTaxInformationItem) {
            // validation for constraint: itemType
            if (!$taxInformationArrayTaxInformationItem instanceof \StructType\TaxInformation) {
                $invalidValues[] = is_object($taxInformationArrayTaxInformationItem) ? get_class($taxInformationArrayTaxInformationItem) : sprintf('%s(%s)', gettype($taxInformationArrayTaxInformationItem), var_export($taxInformationArrayTaxInformationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxInformation property can only contain items of type \StructType\TaxInformation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaxInformation value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxInformation[] $taxInformation
     * @return \ArrayType\TaxInformationArray
     */
    public function setTaxInformation(array $taxInformation = array())
    {
        // validation for constraint: array
        if ('' !== ($taxInformationArrayErrorMessage = self::validateTaxInformationForArrayConstraintsFromSetTaxInformation($taxInformation))) {
            throw new \InvalidArgumentException($taxInformationArrayErrorMessage, __LINE__);
        }
        $this->TaxInformation = $taxInformation;
        return $this;
    }
    /**
     * Add item to TaxInformation value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxInformation $item
     * @return \ArrayType\TaxInformationArray
     */
    public function addToTaxInformation(\StructType\TaxInformation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TaxInformation) {
            throw new \InvalidArgumentException(sprintf('The TaxInformation property can only contain items of type \StructType\TaxInformation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TaxInformation[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\TaxInformation|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\TaxInformation|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\TaxInformation|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\TaxInformation|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\TaxInformation|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TaxInformation
     */
    public function getAttributeName()
    {
        return 'TaxInformation';
    }
}
