<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ShipmentLinkArray ArrayType
 * Meta information extracted from the WSDL
 * - documentation: Link this part and a specified quantity to one or many shipments.
 * @subpackage Arrays
 */
class ShipmentLinkArray extends AbstractStructArrayBase
{
    /**
     * The ShipmentLink
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ns2:ShipmentLink
     * @var \StructType\ShipmentLink[]
     */
    public $ShipmentLink;
    /**
     * Constructor method for ShipmentLinkArray
     * @uses ShipmentLinkArray::setShipmentLink()
     * @param \StructType\ShipmentLink[] $shipmentLink
     */
    public function __construct(array $shipmentLink = array())
    {
        $this
            ->setShipmentLink($shipmentLink);
    }
    /**
     * Get ShipmentLink value
     * @return \StructType\ShipmentLink[]|null
     */
    public function getShipmentLink()
    {
        return $this->ShipmentLink;
    }
    /**
     * This method is responsible for validating the values passed to the setShipmentLink method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipmentLink method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentLinkForArrayConstraintsFromSetShipmentLink(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentLinkArrayShipmentLinkItem) {
            // validation for constraint: itemType
            if (!$shipmentLinkArrayShipmentLinkItem instanceof \StructType\ShipmentLink) {
                $invalidValues[] = is_object($shipmentLinkArrayShipmentLinkItem) ? get_class($shipmentLinkArrayShipmentLinkItem) : sprintf('%s(%s)', gettype($shipmentLinkArrayShipmentLinkItem), var_export($shipmentLinkArrayShipmentLinkItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ShipmentLink property can only contain items of type \StructType\ShipmentLink, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ShipmentLink value
     * @throws \InvalidArgumentException
     * @param \StructType\ShipmentLink[] $shipmentLink
     * @return \ArrayType\ShipmentLinkArray
     */
    public function setShipmentLink(array $shipmentLink = array())
    {
        // validation for constraint: array
        if ('' !== ($shipmentLinkArrayErrorMessage = self::validateShipmentLinkForArrayConstraintsFromSetShipmentLink($shipmentLink))) {
            throw new \InvalidArgumentException($shipmentLinkArrayErrorMessage, __LINE__);
        }
        $this->ShipmentLink = $shipmentLink;
        return $this;
    }
    /**
     * Add item to ShipmentLink value
     * @throws \InvalidArgumentException
     * @param \StructType\ShipmentLink $item
     * @return \ArrayType\ShipmentLinkArray
     */
    public function addToShipmentLink(\StructType\ShipmentLink $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ShipmentLink) {
            throw new \InvalidArgumentException(sprintf('The ShipmentLink property can only contain items of type \StructType\ShipmentLink, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ShipmentLink[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ShipmentLink|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ShipmentLink|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ShipmentLink|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ShipmentLink|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ShipmentLink|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ShipmentLink
     */
    public function getAttributeName()
    {
        return 'ShipmentLink';
    }
}
