<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for PartArray ArrayType
 * Meta information extracted from the WSDL
 * - documentation: An array of product part information. This array should be populated with information from the supplier's Promostandards Product Pricing and Configuration service
 * @subpackage Arrays
 */
class PartArray extends AbstractStructArrayBase
{
    /**
     * The Part
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ns3:Part
     * @var \StructType\Part[]
     */
    public $Part;
    /**
     * Constructor method for PartArray
     * @uses PartArray::setPart()
     * @param \StructType\Part[] $part
     */
    public function __construct(array $part = array())
    {
        $this
            ->setPart($part);
    }
    /**
     * Get Part value
     * @return \StructType\Part[]|null
     */
    public function getPart()
    {
        return $this->Part;
    }
    /**
     * This method is responsible for validating the values passed to the setPart method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPart method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePartForArrayConstraintsFromSetPart(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $partArrayPartItem) {
            // validation for constraint: itemType
            if (!$partArrayPartItem instanceof \StructType\Part) {
                $invalidValues[] = is_object($partArrayPartItem) ? get_class($partArrayPartItem) : sprintf('%s(%s)', gettype($partArrayPartItem), var_export($partArrayPartItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Part property can only contain items of type \StructType\Part, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Part value
     * @throws \InvalidArgumentException
     * @param \StructType\Part[] $part
     * @return \ArrayType\PartArray
     */
    public function setPart(array $part = array())
    {
        // validation for constraint: array
        if ('' !== ($partArrayErrorMessage = self::validatePartForArrayConstraintsFromSetPart($part))) {
            throw new \InvalidArgumentException($partArrayErrorMessage, __LINE__);
        }
        $this->Part = $part;
        return $this;
    }
    /**
     * Add item to Part value
     * @throws \InvalidArgumentException
     * @param \StructType\Part $item
     * @return \ArrayType\PartArray
     */
    public function addToPart(\StructType\Part $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Part) {
            throw new \InvalidArgumentException(sprintf('The Part property can only contain items of type \StructType\Part, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Part[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Part|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Part|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Part|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Part|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Part|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Part
     */
    public function getAttributeName()
    {
        return 'Part';
    }
}
