<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for DecorationArray ArrayType
 * Meta information extracted from the WSDL
 * - documentation: An array of product decoration information
 * @subpackage Arrays
 */
class DecorationArray extends AbstractStructArrayBase
{
    /**
     * The Decoration
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ns2:Decoration
     * @var \StructType\Decoration[]
     */
    public $Decoration;
    /**
     * Constructor method for DecorationArray
     * @uses DecorationArray::setDecoration()
     * @param \StructType\Decoration[] $decoration
     */
    public function __construct(array $decoration = array())
    {
        $this
            ->setDecoration($decoration);
    }
    /**
     * Get Decoration value
     * @return \StructType\Decoration[]|null
     */
    public function getDecoration()
    {
        return $this->Decoration;
    }
    /**
     * This method is responsible for validating the values passed to the setDecoration method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDecoration method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDecorationForArrayConstraintsFromSetDecoration(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $decorationArrayDecorationItem) {
            // validation for constraint: itemType
            if (!$decorationArrayDecorationItem instanceof \StructType\Decoration) {
                $invalidValues[] = is_object($decorationArrayDecorationItem) ? get_class($decorationArrayDecorationItem) : sprintf('%s(%s)', gettype($decorationArrayDecorationItem), var_export($decorationArrayDecorationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Decoration property can only contain items of type \StructType\Decoration, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Decoration value
     * @throws \InvalidArgumentException
     * @param \StructType\Decoration[] $decoration
     * @return \ArrayType\DecorationArray
     */
    public function setDecoration(array $decoration = array())
    {
        // validation for constraint: array
        if ('' !== ($decorationArrayErrorMessage = self::validateDecorationForArrayConstraintsFromSetDecoration($decoration))) {
            throw new \InvalidArgumentException($decorationArrayErrorMessage, __LINE__);
        }
        $this->Decoration = $decoration;
        return $this;
    }
    /**
     * Add item to Decoration value
     * @throws \InvalidArgumentException
     * @param \StructType\Decoration $item
     * @return \ArrayType\DecorationArray
     */
    public function addToDecoration(\StructType\Decoration $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Decoration) {
            throw new \InvalidArgumentException(sprintf('The Decoration property can only contain items of type \StructType\Decoration, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Decoration[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Decoration|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Decoration|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Decoration|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Decoration|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Decoration|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Decoration
     */
    public function getAttributeName()
    {
        return 'Decoration';
    }
}
