<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArtworkFileArray ArrayType
 * @subpackage Arrays
 */
class ArtworkFileArray extends AbstractStructArrayBase
{
    /**
     * The ArtworkFile
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ns2:ArtworkFile
     * @var \StructType\ArtworkFile[]
     */
    public $ArtworkFile;
    /**
     * Constructor method for ArtworkFileArray
     * @uses ArtworkFileArray::setArtworkFile()
     * @param \StructType\ArtworkFile[] $artworkFile
     */
    public function __construct(array $artworkFile = array())
    {
        $this
            ->setArtworkFile($artworkFile);
    }
    /**
     * Get ArtworkFile value
     * @return \StructType\ArtworkFile[]|null
     */
    public function getArtworkFile()
    {
        return $this->ArtworkFile;
    }
    /**
     * This method is responsible for validating the values passed to the setArtworkFile method
     * This method is willingly generated in order to preserve the one-line inline validation within the setArtworkFile method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateArtworkFileForArrayConstraintsFromSetArtworkFile(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $artworkFileArrayArtworkFileItem) {
            // validation for constraint: itemType
            if (!$artworkFileArrayArtworkFileItem instanceof \StructType\ArtworkFile) {
                $invalidValues[] = is_object($artworkFileArrayArtworkFileItem) ? get_class($artworkFileArrayArtworkFileItem) : sprintf('%s(%s)', gettype($artworkFileArrayArtworkFileItem), var_export($artworkFileArrayArtworkFileItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ArtworkFile property can only contain items of type \StructType\ArtworkFile, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ArtworkFile value
     * @throws \InvalidArgumentException
     * @param \StructType\ArtworkFile[] $artworkFile
     * @return \ArrayType\ArtworkFileArray
     */
    public function setArtworkFile(array $artworkFile = array())
    {
        // validation for constraint: array
        if ('' !== ($artworkFileArrayErrorMessage = self::validateArtworkFileForArrayConstraintsFromSetArtworkFile($artworkFile))) {
            throw new \InvalidArgumentException($artworkFileArrayErrorMessage, __LINE__);
        }
        $this->ArtworkFile = $artworkFile;
        return $this;
    }
    /**
     * Add item to ArtworkFile value
     * @throws \InvalidArgumentException
     * @param \StructType\ArtworkFile $item
     * @return \ArrayType\ArtworkFileArray
     */
    public function addToArtworkFile(\StructType\ArtworkFile $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ArtworkFile) {
            throw new \InvalidArgumentException(sprintf('The ArtworkFile property can only contain items of type \StructType\ArtworkFile, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ArtworkFile[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ArtworkFile|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ArtworkFile|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ArtworkFile|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ArtworkFile|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ArtworkFile|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ArtworkFile
     */
    public function getAttributeName()
    {
        return 'ArtworkFile';
    }
}
