<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Typeset StructType
 * @subpackage Structs
 */
class Typeset extends AbstractStructBase
{
    /**
     * The fontSize
     * Meta information extracted from the WSDL
     * - documentation: The font size to use for the typeset
     * - minOccurs: 0
     * @var float
     */
    public $fontSize;
    /**
     * The font
     * Meta information extracted from the WSDL
     * - documentation: The font to use for the typeset
     * - base: xsd:string
     * - maxLength: 64
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $font;
    /**
     * The sequenceNumber
     * Meta information extracted from the WSDL
     * - documentation: The order of the typeset information
     * @var int
     */
    public $sequenceNumber;
    /**
     * The value
     * Meta information extracted from the WSDL
     * - documentation: The typeset to be used on the order
     * - base: xsd:string
     * - maxLength: 1024
     * - minLength: 1
     * @var string
     */
    public $value;
    /**
     * Constructor method for Typeset
     * @uses Typeset::setFontSize()
     * @uses Typeset::setFont()
     * @uses Typeset::setSequenceNumber()
     * @uses Typeset::setValue()
     * @param float $fontSize
     * @param string $font
     * @param int $sequenceNumber
     * @param string $value
     */
    public function __construct($fontSize = null, $font = null, $sequenceNumber = null, $value = null)
    {
        $this
            ->setFontSize($fontSize)
            ->setFont($font)
            ->setSequenceNumber($sequenceNumber)
            ->setValue($value);
    }
    /**
     * Get fontSize value
     * @return float|null
     */
    public function getFontSize()
    {
        return $this->fontSize;
    }
    /**
     * Set fontSize value
     * @param float $fontSize
     * @return \StructType\Typeset
     */
    public function setFontSize($fontSize = null)
    {
        // validation for constraint: float
        if (!is_null($fontSize) && !(is_float($fontSize) || is_numeric($fontSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fontSize, true), gettype($fontSize)), __LINE__);
        }
        $this->fontSize = $fontSize;
        return $this;
    }
    /**
     * Get font value
     * @return string|null
     */
    public function getFont()
    {
        return $this->font;
    }
    /**
     * Set font value
     * @param string $font
     * @return \StructType\Typeset
     */
    public function setFont($font = null)
    {
        // validation for constraint: string
        if (!is_null($font) && !is_string($font)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($font, true), gettype($font)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($font) && mb_strlen($font) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($font)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($font) && mb_strlen($font) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($font)), __LINE__);
        }
        $this->font = $font;
        return $this;
    }
    /**
     * Get sequenceNumber value
     * @return int|null
     */
    public function getSequenceNumber()
    {
        return $this->sequenceNumber;
    }
    /**
     * Set sequenceNumber value
     * @param int $sequenceNumber
     * @return \StructType\Typeset
     */
    public function setSequenceNumber($sequenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceNumber) && !(is_int($sequenceNumber) || ctype_digit($sequenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sequenceNumber, true), gettype($sequenceNumber)), __LINE__);
        }
        $this->sequenceNumber = $sequenceNumber;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \StructType\Typeset
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        // validation for constraint: maxLength(1024)
        if (!is_null($value) && mb_strlen($value) > 1024) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1024', mb_strlen($value)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($value) && mb_strlen($value) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
}
