<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ThirdPartyAccount StructType
 * @subpackage Structs
 */
class ThirdPartyAccount extends AbstractStructBase
{
    /**
     * The accountName
     * Meta information extracted from the WSDL
     * - documentation: The name of the account that will be invoiced for the purchase order.
     * - base: xsd:string
     * - maxLength: 64
     * - minLength: 1
     * - ref: ns2:accountName
     * @var string
     */
    public $accountName;
    /**
     * The accountNumber
     * Meta information extracted from the WSDL
     * - documentation: The number of the account that will be invoiced for the purchase order.
     * - base: xsd:string
     * - maxLength: 64
     * - minLength: 1
     * - ref: ns2:accountNumber
     * @var string
     */
    public $accountNumber;
    /**
     * The ContactDetails
     * Meta information extracted from the WSDL
     * - ref: ns2:ContactDetails
     * @var \StructType\ContactDetails
     */
    public $ContactDetails;
    /**
     * Constructor method for ThirdPartyAccount
     * @uses ThirdPartyAccount::setAccountName()
     * @uses ThirdPartyAccount::setAccountNumber()
     * @uses ThirdPartyAccount::setContactDetails()
     * @param string $accountName
     * @param string $accountNumber
     * @param \StructType\ContactDetails $contactDetails
     */
    public function __construct($accountName = null, $accountNumber = null, \StructType\ContactDetails $contactDetails = null)
    {
        $this
            ->setAccountName($accountName)
            ->setAccountNumber($accountNumber)
            ->setContactDetails($contactDetails);
    }
    /**
     * Get accountName value
     * @return string|null
     */
    public function getAccountName()
    {
        return $this->accountName;
    }
    /**
     * Set accountName value
     * @param string $accountName
     * @return \StructType\ThirdPartyAccount
     */
    public function setAccountName($accountName = null)
    {
        // validation for constraint: string
        if (!is_null($accountName) && !is_string($accountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountName, true), gettype($accountName)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($accountName) && mb_strlen($accountName) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($accountName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($accountName) && mb_strlen($accountName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($accountName)), __LINE__);
        }
        $this->accountName = $accountName;
        return $this;
    }
    /**
     * Get accountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->accountNumber;
    }
    /**
     * Set accountNumber value
     * @param string $accountNumber
     * @return \StructType\ThirdPartyAccount
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($accountNumber) && mb_strlen($accountNumber) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($accountNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($accountNumber) && mb_strlen($accountNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($accountNumber)), __LINE__);
        }
        $this->accountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get ContactDetails value
     * @return \StructType\ContactDetails|null
     */
    public function getContactDetails()
    {
        return $this->ContactDetails;
    }
    /**
     * Set ContactDetails value
     * @param \StructType\ContactDetails $contactDetails
     * @return \StructType\ThirdPartyAccount
     */
    public function setContactDetails(\StructType\ContactDetails $contactDetails = null)
    {
        $this->ContactDetails = $contactDetails;
        return $this;
    }
}
