<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxInformation StructType
 * @subpackage Structs
 */
class TaxInformation extends AbstractStructBase
{
    /**
     * The taxJurisdiction
     * Meta information extracted from the WSDL
     * - documentation: Tax Jurisdictions
     * - base: xsd:string
     * - maxLength: 64
     * - maxOccurs: unbounded
     * - minLength: 1
     * @var string[]
     */
    public $taxJurisdiction;
    /**
     * The taxExempt
     * Meta information extracted from the WSDL
     * - documentation: Tax Exempt
     * @var bool
     */
    public $taxExempt;
    /**
     * The taxId
     * Meta information extracted from the WSDL
     * - documentation: The purchasers tax identifier
     * - base: xsd:string
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $taxId;
    /**
     * The taxType
     * Meta information extracted from the WSDL
     * - documentation: The type of tax the identifier applies to.
     * - base: ns2:TaxTypeType
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $taxType;
    /**
     * The taxAmount
     * Meta information extracted from the WSDL
     * - documentation: The amount of tax for this purchase order
     * - minOccurs: 0
     * @var float
     */
    public $taxAmount;
    /**
     * Constructor method for TaxInformation
     * @uses TaxInformation::setTaxJurisdiction()
     * @uses TaxInformation::setTaxExempt()
     * @uses TaxInformation::setTaxId()
     * @uses TaxInformation::setTaxType()
     * @uses TaxInformation::setTaxAmount()
     * @param string[] $taxJurisdiction
     * @param bool $taxExempt
     * @param string $taxId
     * @param string $taxType
     * @param float $taxAmount
     */
    public function __construct(array $taxJurisdiction = array(), $taxExempt = null, $taxId = null, $taxType = null, $taxAmount = null)
    {
        $this
            ->setTaxJurisdiction($taxJurisdiction)
            ->setTaxExempt($taxExempt)
            ->setTaxId($taxId)
            ->setTaxType($taxType)
            ->setTaxAmount($taxAmount);
    }
    /**
     * Get taxJurisdiction value
     * @return string[]|null
     */
    public function getTaxJurisdiction()
    {
        return $this->taxJurisdiction;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxJurisdiction method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxJurisdiction method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxJurisdictionForArrayConstraintsFromSetTaxJurisdiction(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxInformationTaxJurisdictionItem) {
            // validation for constraint: itemType
            if (!is_string($taxInformationTaxJurisdictionItem)) {
                $invalidValues[] = is_object($taxInformationTaxJurisdictionItem) ? get_class($taxInformationTaxJurisdictionItem) : sprintf('%s(%s)', gettype($taxInformationTaxJurisdictionItem), var_export($taxInformationTaxJurisdictionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The taxJurisdiction property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setTaxJurisdiction method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxJurisdiction method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxJurisdictionForMaxLengthConstraintFromSetTaxJurisdiction($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxInformationTaxJurisdictionItem) {
            // validation for constraint: maxLength(64)
            if (mb_strlen($taxInformationTaxJurisdictionItem) > 64) {
                $invalidValues[] = var_export($taxInformationTaxJurisdictionItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be less than or equal to 64', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setTaxJurisdiction method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxJurisdiction method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxJurisdictionForMinLengthConstraintFromSetTaxJurisdiction($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxInformationTaxJurisdictionItem) {
            // validation for constraint: minLength(1)
            if (mb_strlen($taxInformationTaxJurisdictionItem) < 1) {
                $invalidValues[] = var_export($taxInformationTaxJurisdictionItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be greater than or equal to 1', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set taxJurisdiction value
     * @throws \InvalidArgumentException
     * @param string[] $taxJurisdiction
     * @return \StructType\TaxInformation
     */
    public function setTaxJurisdiction(array $taxJurisdiction = array())
    {
        // validation for constraint: array
        if ('' !== ($taxJurisdictionArrayErrorMessage = self::validateTaxJurisdictionForArrayConstraintsFromSetTaxJurisdiction($taxJurisdiction))) {
            throw new \InvalidArgumentException($taxJurisdictionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(64)
        if ('' !== ($taxJurisdictionMaxLengthErrorMessage = self::validateTaxJurisdictionForMaxLengthConstraintFromSetTaxJurisdiction($taxJurisdiction))) {
            throw new \InvalidArgumentException($taxJurisdictionMaxLengthErrorMessage, __LINE__);
        }
        // validation for constraint: minLength(1)
        if ('' !== ($taxJurisdictionMinLengthErrorMessage = self::validateTaxJurisdictionForMinLengthConstraintFromSetTaxJurisdiction($taxJurisdiction))) {
            throw new \InvalidArgumentException($taxJurisdictionMinLengthErrorMessage, __LINE__);
        }
        $this->taxJurisdiction = $taxJurisdiction;
        return $this;
    }
    /**
     * Add item to taxJurisdiction value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\TaxInformation
     */
    public function addToTaxJurisdiction($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The taxJurisdiction property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (mb_strlen($item) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (mb_strlen($item) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($item)), __LINE__);
        }
        $this->taxJurisdiction[] = $item;
        return $this;
    }
    /**
     * Get taxExempt value
     * @return bool|null
     */
    public function getTaxExempt()
    {
        return $this->taxExempt;
    }
    /**
     * Set taxExempt value
     * @param bool $taxExempt
     * @return \StructType\TaxInformation
     */
    public function setTaxExempt($taxExempt = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxExempt) && !is_bool($taxExempt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxExempt, true), gettype($taxExempt)), __LINE__);
        }
        $this->taxExempt = $taxExempt;
        return $this;
    }
    /**
     * Get taxId value
     * @return string|null
     */
    public function getTaxId()
    {
        return $this->taxId;
    }
    /**
     * Set taxId value
     * @param string $taxId
     * @return \StructType\TaxInformation
     */
    public function setTaxId($taxId = null)
    {
        // validation for constraint: string
        if (!is_null($taxId) && !is_string($taxId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxId, true), gettype($taxId)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($taxId) && mb_strlen($taxId) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($taxId)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($taxId) && mb_strlen($taxId) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($taxId)), __LINE__);
        }
        $this->taxId = $taxId;
        return $this;
    }
    /**
     * Get taxType value
     * @return string|null
     */
    public function getTaxType()
    {
        return $this->taxType;
    }
    /**
     * Set taxType value
     * @param string $taxType
     * @return \StructType\TaxInformation
     */
    public function setTaxType($taxType = null)
    {
        // validation for constraint: string
        if (!is_null($taxType) && !is_string($taxType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxType, true), gettype($taxType)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($taxType) && mb_strlen($taxType) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($taxType)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($taxType) && mb_strlen($taxType) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($taxType)), __LINE__);
        }
        $this->taxType = $taxType;
        return $this;
    }
    /**
     * Get taxAmount value
     * @return float|null
     */
    public function getTaxAmount()
    {
        return $this->taxAmount;
    }
    /**
     * Set taxAmount value
     * @param float $taxAmount
     * @return \StructType\TaxInformation
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxAmount) && !(is_float($taxAmount) || is_numeric($taxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxAmount, true), gettype($taxAmount)), __LINE__);
        }
        $this->taxAmount = $taxAmount;
        return $this;
    }
}
