<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentLink StructType
 * @subpackage Structs
 */
class ShipmentLink extends AbstractStructBase
{
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - ref: ns2:Quantity
     * @var \StructType\Quantity
     */
    public $Quantity;
    /**
     * The shipmentId
     * Meta information extracted from the WSDL
     * - ref: ns2:shipmentId
     * @var int
     */
    public $shipmentId;
    /**
     * Constructor method for ShipmentLink
     * @uses ShipmentLink::setQuantity()
     * @uses ShipmentLink::setShipmentId()
     * @param \StructType\Quantity $quantity
     * @param int $shipmentId
     */
    public function __construct(\StructType\Quantity $quantity = null, $shipmentId = null)
    {
        $this
            ->setQuantity($quantity)
            ->setShipmentId($shipmentId);
    }
    /**
     * Get Quantity value
     * @return \StructType\Quantity|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param \StructType\Quantity $quantity
     * @return \StructType\ShipmentLink
     */
    public function setQuantity(\StructType\Quantity $quantity = null)
    {
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get shipmentId value
     * @return int|null
     */
    public function getShipmentId()
    {
        return $this->shipmentId;
    }
    /**
     * Set shipmentId value
     * @param int $shipmentId
     * @return \StructType\ShipmentLink
     */
    public function setShipmentId($shipmentId = null)
    {
        // validation for constraint: int
        if (!is_null($shipmentId) && !(is_int($shipmentId) || ctype_digit($shipmentId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($shipmentId, true), gettype($shipmentId)), __LINE__);
        }
        $this->shipmentId = $shipmentId;
        return $this;
    }
}
