<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Shipment StructType
 * Meta information extracted from the WSDL
 * - documentation: The details on the freight: carrier and service
 * @subpackage Structs
 */
class Shipment extends AbstractStructBase
{
    /**
     * The shipReferences
     * Meta information extracted from the WSDL
     * - documentation: Array of two strings max
     * - base: xsd:string
     * - maxLength: 64
     * - maxOccurs: 2
     * - minLength: 1
     * - minOccurs: 0
     * @var string[]
     */
    public $shipReferences;
    /**
     * The comments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns2:comments
     * @var string
     */
    public $comments;
    /**
     * The ThirdPartyAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns2:ThirdPartyAccount
     * @var \StructType\ThirdPartyAccount
     */
    public $ThirdPartyAccount;
    /**
     * The allowConsolidation
     * Meta information extracted from the WSDL
     * - documentation: Allow consolidation of shipments
     * @var bool
     */
    public $allowConsolidation;
    /**
     * The blindShip
     * Meta information extracted from the WSDL
     * - documentation: Require blind shipping
     * @var bool
     */
    public $blindShip;
    /**
     * The packingListRequired
     * Meta information extracted from the WSDL
     * - documentation: Packing list required
     * @var bool
     */
    public $packingListRequired;
    /**
     * The FreightDetails
     * Meta information extracted from the WSDL
     * - ref: ns2:FreightDetails
     * @var \StructType\FreightDetails
     */
    public $FreightDetails;
    /**
     * The ShipTo
     * Meta information extracted from the WSDL
     * - ref: ns2:ShipTo
     * @var \StructType\ShipTo
     */
    public $ShipTo;
    /**
     * Constructor method for Shipment
     * @uses Shipment::setShipReferences()
     * @uses Shipment::setComments()
     * @uses Shipment::setThirdPartyAccount()
     * @uses Shipment::setAllowConsolidation()
     * @uses Shipment::setBlindShip()
     * @uses Shipment::setPackingListRequired()
     * @uses Shipment::setFreightDetails()
     * @uses Shipment::setShipTo()
     * @param string[] $shipReferences
     * @param string $comments
     * @param \StructType\ThirdPartyAccount $thirdPartyAccount
     * @param bool $allowConsolidation
     * @param bool $blindShip
     * @param bool $packingListRequired
     * @param \StructType\FreightDetails $freightDetails
     * @param \StructType\ShipTo $shipTo
     */
    public function __construct(array $shipReferences = array(), $comments = null, \StructType\ThirdPartyAccount $thirdPartyAccount = null, $allowConsolidation = null, $blindShip = null, $packingListRequired = null, \StructType\FreightDetails $freightDetails = null, \StructType\ShipTo $shipTo = null)
    {
        $this
            ->setShipReferences($shipReferences)
            ->setComments($comments)
            ->setThirdPartyAccount($thirdPartyAccount)
            ->setAllowConsolidation($allowConsolidation)
            ->setBlindShip($blindShip)
            ->setPackingListRequired($packingListRequired)
            ->setFreightDetails($freightDetails)
            ->setShipTo($shipTo);
    }
    /**
     * Get shipReferences value
     * @return string[]|null
     */
    public function getShipReferences()
    {
        return $this->shipReferences;
    }
    /**
     * This method is responsible for validating the values passed to the setShipReferences method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipReferences method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipReferencesForArrayConstraintsFromSetShipReferences(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentShipReferencesItem) {
            // validation for constraint: itemType
            if (!is_string($shipmentShipReferencesItem)) {
                $invalidValues[] = is_object($shipmentShipReferencesItem) ? get_class($shipmentShipReferencesItem) : sprintf('%s(%s)', gettype($shipmentShipReferencesItem), var_export($shipmentShipReferencesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The shipReferences property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setShipReferences method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipReferences method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipReferencesForMaxLengthConstraintFromSetShipReferences($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentShipReferencesItem) {
            // validation for constraint: maxLength(64)
            if (mb_strlen($shipmentShipReferencesItem) > 64) {
                $invalidValues[] = var_export($shipmentShipReferencesItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be less than or equal to 64', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setShipReferences method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipReferences method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipReferencesForMinLengthConstraintFromSetShipReferences($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentShipReferencesItem) {
            // validation for constraint: minLength(1)
            if (mb_strlen($shipmentShipReferencesItem) < 1) {
                $invalidValues[] = var_export($shipmentShipReferencesItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be greater than or equal to 1', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set shipReferences value
     * @throws \InvalidArgumentException
     * @param string[] $shipReferences
     * @return \StructType\Shipment
     */
    public function setShipReferences(array $shipReferences = array())
    {
        // validation for constraint: array
        if ('' !== ($shipReferencesArrayErrorMessage = self::validateShipReferencesForArrayConstraintsFromSetShipReferences($shipReferences))) {
            throw new \InvalidArgumentException($shipReferencesArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(64)
        if ('' !== ($shipReferencesMaxLengthErrorMessage = self::validateShipReferencesForMaxLengthConstraintFromSetShipReferences($shipReferences))) {
            throw new \InvalidArgumentException($shipReferencesMaxLengthErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($shipReferences) && count($shipReferences) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($shipReferences)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if ('' !== ($shipReferencesMinLengthErrorMessage = self::validateShipReferencesForMinLengthConstraintFromSetShipReferences($shipReferences))) {
            throw new \InvalidArgumentException($shipReferencesMinLengthErrorMessage, __LINE__);
        }
        $this->shipReferences = $shipReferences;
        return $this;
    }
    /**
     * Add item to shipReferences value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Shipment
     */
    public function addToShipReferences($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The shipReferences property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (mb_strlen($item) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->shipReferences) && count($this->shipReferences) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->shipReferences)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (mb_strlen($item) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($item)), __LINE__);
        }
        $this->shipReferences[] = $item;
        return $this;
    }
    /**
     * Get comments value
     * @return string|null
     */
    public function getComments()
    {
        return $this->comments;
    }
    /**
     * Set comments value
     * @param string $comments
     * @return \StructType\Shipment
     */
    public function setComments($comments = null)
    {
        // validation for constraint: string
        if (!is_null($comments) && !is_string($comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comments, true), gettype($comments)), __LINE__);
        }
        $this->comments = $comments;
        return $this;
    }
    /**
     * Get ThirdPartyAccount value
     * @return \StructType\ThirdPartyAccount|null
     */
    public function getThirdPartyAccount()
    {
        return $this->ThirdPartyAccount;
    }
    /**
     * Set ThirdPartyAccount value
     * @param \StructType\ThirdPartyAccount $thirdPartyAccount
     * @return \StructType\Shipment
     */
    public function setThirdPartyAccount(\StructType\ThirdPartyAccount $thirdPartyAccount = null)
    {
        $this->ThirdPartyAccount = $thirdPartyAccount;
        return $this;
    }
    /**
     * Get allowConsolidation value
     * @return bool|null
     */
    public function getAllowConsolidation()
    {
        return $this->allowConsolidation;
    }
    /**
     * Set allowConsolidation value
     * @param bool $allowConsolidation
     * @return \StructType\Shipment
     */
    public function setAllowConsolidation($allowConsolidation = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowConsolidation) && !is_bool($allowConsolidation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowConsolidation, true), gettype($allowConsolidation)), __LINE__);
        }
        $this->allowConsolidation = $allowConsolidation;
        return $this;
    }
    /**
     * Get blindShip value
     * @return bool|null
     */
    public function getBlindShip()
    {
        return $this->blindShip;
    }
    /**
     * Set blindShip value
     * @param bool $blindShip
     * @return \StructType\Shipment
     */
    public function setBlindShip($blindShip = null)
    {
        // validation for constraint: boolean
        if (!is_null($blindShip) && !is_bool($blindShip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($blindShip, true), gettype($blindShip)), __LINE__);
        }
        $this->blindShip = $blindShip;
        return $this;
    }
    /**
     * Get packingListRequired value
     * @return bool|null
     */
    public function getPackingListRequired()
    {
        return $this->packingListRequired;
    }
    /**
     * Set packingListRequired value
     * @param bool $packingListRequired
     * @return \StructType\Shipment
     */
    public function setPackingListRequired($packingListRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($packingListRequired) && !is_bool($packingListRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($packingListRequired, true), gettype($packingListRequired)), __LINE__);
        }
        $this->packingListRequired = $packingListRequired;
        return $this;
    }
    /**
     * Get FreightDetails value
     * @return \StructType\FreightDetails|null
     */
    public function getFreightDetails()
    {
        return $this->FreightDetails;
    }
    /**
     * Set FreightDetails value
     * @param \StructType\FreightDetails $freightDetails
     * @return \StructType\Shipment
     */
    public function setFreightDetails(\StructType\FreightDetails $freightDetails = null)
    {
        $this->FreightDetails = $freightDetails;
        return $this;
    }
    /**
     * Get ShipTo value
     * @return \StructType\ShipTo|null
     */
    public function getShipTo()
    {
        return $this->ShipTo;
    }
    /**
     * Set ShipTo value
     * @param \StructType\ShipTo $shipTo
     * @return \StructType\Shipment
     */
    public function setShipTo(\StructType\ShipTo $shipTo = null)
    {
        $this->ShipTo = $shipTo;
        return $this;
    }
}
