<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipTo StructType
 * Meta information extracted from the WSDL
 * - documentation: The shipment Id
 * @subpackage Structs
 */
class ShipTo extends AbstractStructBase
{
    /**
     * The customerPickup
     * Meta information extracted from the WSDL
     * - documentation: The shipment will be a pickup and will not be shipped.
     * @var bool
     */
    public $customerPickup;
    /**
     * The ContactDetails
     * Meta information extracted from the WSDL
     * - ref: ns2:ContactDetails
     * @var \StructType\ContactDetails
     */
    public $ContactDetails;
    /**
     * The shipmentId
     * Meta information extracted from the WSDL
     * - ref: ns2:shipmentId
     * @var int
     */
    public $shipmentId;
    /**
     * Constructor method for ShipTo
     * @uses ShipTo::setCustomerPickup()
     * @uses ShipTo::setContactDetails()
     * @uses ShipTo::setShipmentId()
     * @param bool $customerPickup
     * @param \StructType\ContactDetails $contactDetails
     * @param int $shipmentId
     */
    public function __construct($customerPickup = null, \StructType\ContactDetails $contactDetails = null, $shipmentId = null)
    {
        $this
            ->setCustomerPickup($customerPickup)
            ->setContactDetails($contactDetails)
            ->setShipmentId($shipmentId);
    }
    /**
     * Get customerPickup value
     * @return bool|null
     */
    public function getCustomerPickup()
    {
        return $this->customerPickup;
    }
    /**
     * Set customerPickup value
     * @param bool $customerPickup
     * @return \StructType\ShipTo
     */
    public function setCustomerPickup($customerPickup = null)
    {
        // validation for constraint: boolean
        if (!is_null($customerPickup) && !is_bool($customerPickup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($customerPickup, true), gettype($customerPickup)), __LINE__);
        }
        $this->customerPickup = $customerPickup;
        return $this;
    }
    /**
     * Get ContactDetails value
     * @return \StructType\ContactDetails|null
     */
    public function getContactDetails()
    {
        return $this->ContactDetails;
    }
    /**
     * Set ContactDetails value
     * @param \StructType\ContactDetails $contactDetails
     * @return \StructType\ShipTo
     */
    public function setContactDetails(\StructType\ContactDetails $contactDetails = null)
    {
        $this->ContactDetails = $contactDetails;
        return $this;
    }
    /**
     * Get shipmentId value
     * @return int|null
     */
    public function getShipmentId()
    {
        return $this->shipmentId;
    }
    /**
     * Set shipmentId value
     * @param int $shipmentId
     * @return \StructType\ShipTo
     */
    public function setShipmentId($shipmentId = null)
    {
        // validation for constraint: int
        if (!is_null($shipmentId) && !(is_int($shipmentId) || ctype_digit($shipmentId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($shipmentId, true), gettype($shipmentId)), __LINE__);
        }
        $this->shipmentId = $shipmentId;
        return $this;
    }
}
