<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Part StructType
 * Meta information extracted from the WSDL
 * - documentation: The extended Price | The unit price | An array of location link Ids. This links the part to its configured locations. | The quantity object that contains the value and unit of measure | The description | The part Id | An identifier
 * that links common line item parts together
 * @subpackage Structs
 */
class Part extends AbstractStructBase
{
    /**
     * The partGroup
     * Meta information extracted from the WSDL
     * - documentation: The part Group
     * - base: xsd:token
     * - maxLength: 64
     * - minLength: 1
     * - minOccurs: 0
     * - ref: ns2:partGroup
     * @var string
     */
    public $partGroup;
    /**
     * The partId
     * Meta information extracted from the WSDL
     * - documentation: The part ID
     * - base: xsd:token
     * - maxLength: 64
     * - minLength: 1
     * - ref: ns2:partId
     * @var string
     */
    public $partId;
    /**
     * The customerPartId
     * Meta information extracted from the WSDL
     * - documentation: How the part is being represented to the distributor's customer
     * - base: xsd:string
     * - maxLength: 64
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $customerPartId;
    /**
     * The customerSupplied
     * Meta information extracted from the WSDL
     * - documentation: The part will be supplied by the customer or another entity other than the supplier
     * @var bool
     */
    public $customerSupplied;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns2:description
     * @var string
     */
    public $description;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - ref: ns2:Quantity
     * @var \StructType\Quantity
     */
    public $Quantity;
    /**
     * The locationLinkId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ns2:locationLinkId
     * @var int[]
     */
    public $locationLinkId;
    /**
     * The unitPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns2:unitPrice
     * @var float
     */
    public $unitPrice;
    /**
     * The extendedPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns2:extendedPrice
     * @var float
     */
    public $extendedPrice;
    /**
     * The ShipmentLinkArray
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\ShipmentLinkArray
     */
    public $ShipmentLinkArray;
    /**
     * Constructor method for Part
     * @uses Part::setPartGroup()
     * @uses Part::setPartId()
     * @uses Part::setCustomerPartId()
     * @uses Part::setCustomerSupplied()
     * @uses Part::setDescription()
     * @uses Part::setQuantity()
     * @uses Part::setLocationLinkId()
     * @uses Part::setUnitPrice()
     * @uses Part::setExtendedPrice()
     * @uses Part::setShipmentLinkArray()
     * @param string $partGroup
     * @param string $partId
     * @param string $customerPartId
     * @param bool $customerSupplied
     * @param string $description
     * @param \StructType\Quantity $quantity
     * @param int[] $locationLinkId
     * @param float $unitPrice
     * @param float $extendedPrice
     * @param \ArrayType\ShipmentLinkArray $shipmentLinkArray
     */
    public function __construct($partGroup = null, $partId = null, $customerPartId = null, $customerSupplied = null, $description = null, \StructType\Quantity $quantity = null, array $locationLinkId = array(), $unitPrice = null, $extendedPrice = null, \ArrayType\ShipmentLinkArray $shipmentLinkArray = null)
    {
        $this
            ->setPartGroup($partGroup)
            ->setPartId($partId)
            ->setCustomerPartId($customerPartId)
            ->setCustomerSupplied($customerSupplied)
            ->setDescription($description)
            ->setQuantity($quantity)
            ->setLocationLinkId($locationLinkId)
            ->setUnitPrice($unitPrice)
            ->setExtendedPrice($extendedPrice)
            ->setShipmentLinkArray($shipmentLinkArray);
    }
    /**
     * Get partGroup value
     * @return string|null
     */
    public function getPartGroup()
    {
        return $this->partGroup;
    }
    /**
     * Set partGroup value
     * @param string $partGroup
     * @return \StructType\Part
     */
    public function setPartGroup($partGroup = null)
    {
        // validation for constraint: string
        if (!is_null($partGroup) && !is_string($partGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partGroup, true), gettype($partGroup)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($partGroup) && mb_strlen($partGroup) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($partGroup)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($partGroup) && mb_strlen($partGroup) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($partGroup)), __LINE__);
        }
        $this->partGroup = $partGroup;
        return $this;
    }
    /**
     * Get partId value
     * @return string|null
     */
    public function getPartId()
    {
        return $this->partId;
    }
    /**
     * Set partId value
     * @param string $partId
     * @return \StructType\Part
     */
    public function setPartId($partId = null)
    {
        // validation for constraint: string
        if (!is_null($partId) && !is_string($partId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partId, true), gettype($partId)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($partId) && mb_strlen($partId) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($partId)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($partId) && mb_strlen($partId) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($partId)), __LINE__);
        }
        $this->partId = $partId;
        return $this;
    }
    /**
     * Get customerPartId value
     * @return string|null
     */
    public function getCustomerPartId()
    {
        return $this->customerPartId;
    }
    /**
     * Set customerPartId value
     * @param string $customerPartId
     * @return \StructType\Part
     */
    public function setCustomerPartId($customerPartId = null)
    {
        // validation for constraint: string
        if (!is_null($customerPartId) && !is_string($customerPartId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerPartId, true), gettype($customerPartId)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($customerPartId) && mb_strlen($customerPartId) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($customerPartId)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($customerPartId) && mb_strlen($customerPartId) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($customerPartId)), __LINE__);
        }
        $this->customerPartId = $customerPartId;
        return $this;
    }
    /**
     * Get customerSupplied value
     * @return bool|null
     */
    public function getCustomerSupplied()
    {
        return $this->customerSupplied;
    }
    /**
     * Set customerSupplied value
     * @param bool $customerSupplied
     * @return \StructType\Part
     */
    public function setCustomerSupplied($customerSupplied = null)
    {
        // validation for constraint: boolean
        if (!is_null($customerSupplied) && !is_bool($customerSupplied)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($customerSupplied, true), gettype($customerSupplied)), __LINE__);
        }
        $this->customerSupplied = $customerSupplied;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\Part
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get Quantity value
     * @return \StructType\Quantity|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param \StructType\Quantity $quantity
     * @return \StructType\Part
     */
    public function setQuantity(\StructType\Quantity $quantity = null)
    {
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get locationLinkId value
     * @return int[]|null
     */
    public function getLocationLinkId()
    {
        return $this->locationLinkId;
    }
    /**
     * This method is responsible for validating the values passed to the setLocationLinkId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocationLinkId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocationLinkIdForArrayConstraintsFromSetLocationLinkId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $partLocationLinkIdItem) {
            // validation for constraint: itemType
            if (!(is_int($partLocationLinkIdItem) || ctype_digit($partLocationLinkIdItem))) {
                $invalidValues[] = is_object($partLocationLinkIdItem) ? get_class($partLocationLinkIdItem) : sprintf('%s(%s)', gettype($partLocationLinkIdItem), var_export($partLocationLinkIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The locationLinkId property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set locationLinkId value
     * @throws \InvalidArgumentException
     * @param int[] $locationLinkId
     * @return \StructType\Part
     */
    public function setLocationLinkId(array $locationLinkId = array())
    {
        // validation for constraint: array
        if ('' !== ($locationLinkIdArrayErrorMessage = self::validateLocationLinkIdForArrayConstraintsFromSetLocationLinkId($locationLinkId))) {
            throw new \InvalidArgumentException($locationLinkIdArrayErrorMessage, __LINE__);
        }
        $this->locationLinkId = $locationLinkId;
        return $this;
    }
    /**
     * Add item to locationLinkId value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\Part
     */
    public function addToLocationLinkId($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The locationLinkId property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->locationLinkId[] = $item;
        return $this;
    }
    /**
     * Get unitPrice value
     * @return float|null
     */
    public function getUnitPrice()
    {
        return $this->unitPrice;
    }
    /**
     * Set unitPrice value
     * @param float $unitPrice
     * @return \StructType\Part
     */
    public function setUnitPrice($unitPrice = null)
    {
        // validation for constraint: float
        if (!is_null($unitPrice) && !(is_float($unitPrice) || is_numeric($unitPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unitPrice, true), gettype($unitPrice)), __LINE__);
        }
        $this->unitPrice = $unitPrice;
        return $this;
    }
    /**
     * Get extendedPrice value
     * @return float|null
     */
    public function getExtendedPrice()
    {
        return $this->extendedPrice;
    }
    /**
     * Set extendedPrice value
     * @param float $extendedPrice
     * @return \StructType\Part
     */
    public function setExtendedPrice($extendedPrice = null)
    {
        // validation for constraint: float
        if (!is_null($extendedPrice) && !(is_float($extendedPrice) || is_numeric($extendedPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($extendedPrice, true), gettype($extendedPrice)), __LINE__);
        }
        $this->extendedPrice = $extendedPrice;
        return $this;
    }
    /**
     * Get ShipmentLinkArray value
     * @return \ArrayType\ShipmentLinkArray|null
     */
    public function getShipmentLinkArray()
    {
        return $this->ShipmentLinkArray;
    }
    /**
     * Set ShipmentLinkArray value
     * @param \ArrayType\ShipmentLinkArray $shipmentLinkArray
     * @return \StructType\Part
     */
    public function setShipmentLinkArray(\ArrayType\ShipmentLinkArray $shipmentLinkArray = null)
    {
        $this->ShipmentLinkArray = $shipmentLinkArray;
        return $this;
    }
}
