<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LineItem StructType
 * @subpackage Structs
 */
class LineItem extends AbstractStructBase
{
    /**
     * The lineNumber
     * Meta information extracted from the WSDL
     * - documentation: The line number of the line item
     * @var int
     */
    public $lineNumber;
    /**
     * The lineReferenceId
     * Meta information extracted from the WSDL
     * - documentation: The line identifier used by the distributor
     * - base: xsd:string
     * - maxLength: 64
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $lineReferenceId;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - ref: ns3:description
     * @var string
     */
    public $description;
    /**
     * The lineType
     * Meta information extracted from the WSDL
     * - documentation: The type of order
     * - base: ns3:LineTypeType
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $lineType;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns3:Quantity
     * @var \StructType\Quantity
     */
    public $Quantity;
    /**
     * The fobId
     * Meta information extracted from the WSDL
     * - documentation: Used to indicate the FOB point. Use fobId from the supplier's Product Pricing and Configuration Service to populate this information.
     * - base: xsd:token
     * - maxLength: 64
     * - minLength: 1
     * - minOccurs: 0
     * - ref: ns3:fobId
     * @var string
     */
    public $fobId;
    /**
     * The ToleranceDetails
     * Meta information extracted from the WSDL
     * - ref: ns3:ToleranceDetails
     * @var \StructType\ToleranceDetails
     */
    public $ToleranceDetails;
    /**
     * The allowPartialShipments
     * Meta information extracted from the WSDL
     * - documentation: Allow partial shipments of this line item
     * @var bool
     */
    public $allowPartialShipments;
    /**
     * The unitPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns3:unitPrice
     * @var float
     */
    public $unitPrice;
    /**
     * The lineItemTotal
     * @var float
     */
    public $lineItemTotal;
    /**
     * The requestedShipDate
     * Meta information extracted from the WSDL
     * - documentation: The date the line item is requested to ship from the FOB point.
     * - minOccurs: 0
     * @var string
     */
    public $requestedShipDate;
    /**
     * The requestedInHandsDate
     * Meta information extracted from the WSDL
     * - documentation: The date the line item is requested to arrive at the shipping destination
     * - minOccurs: 0
     * @var string
     */
    public $requestedInHandsDate;
    /**
     * The referenceSalesQuote
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 64
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $referenceSalesQuote;
    /**
     * The Program
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns3:Program
     * @var \StructType\Program
     */
    public $Program;
    /**
     * The endCustomerSalesOrder
     * Meta information extracted from the WSDL
     * - documentation: The distributor's order number provided to the end customer
     * - base: xsd:string
     * - maxLength: 64
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $endCustomerSalesOrder;
    /**
     * The productId
     * Meta information extracted from the WSDL
     * - documentation: The product Id
     * - base: xsd:token
     * - maxLength: 64
     * - minLength: 1
     * - minOccurs: 0
     * - ref: ns3:productId
     * @var string
     */
    public $productId;
    /**
     * The customerProductId
     * Meta information extracted from the WSDL
     * - documentation: The distributor's product id
     * - base: xsd:string
     * - maxLength: 64
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $customerProductId;
    /**
     * The lineItemGroupingId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns3:lineItemGroupingId
     * @var int
     */
    public $lineItemGroupingId;
    /**
     * The PartArray
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\PartArray
     */
    public $PartArray;
    /**
     * The Configuration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns3:Configuration
     * @var \StructType\Configuration
     */
    public $Configuration;
    /**
     * Constructor method for LineItem
     * @uses LineItem::setLineNumber()
     * @uses LineItem::setLineReferenceId()
     * @uses LineItem::setDescription()
     * @uses LineItem::setLineType()
     * @uses LineItem::setQuantity()
     * @uses LineItem::setFobId()
     * @uses LineItem::setToleranceDetails()
     * @uses LineItem::setAllowPartialShipments()
     * @uses LineItem::setUnitPrice()
     * @uses LineItem::setLineItemTotal()
     * @uses LineItem::setRequestedShipDate()
     * @uses LineItem::setRequestedInHandsDate()
     * @uses LineItem::setReferenceSalesQuote()
     * @uses LineItem::setProgram()
     * @uses LineItem::setEndCustomerSalesOrder()
     * @uses LineItem::setProductId()
     * @uses LineItem::setCustomerProductId()
     * @uses LineItem::setLineItemGroupingId()
     * @uses LineItem::setPartArray()
     * @uses LineItem::setConfiguration()
     * @param int $lineNumber
     * @param string $lineReferenceId
     * @param string $description
     * @param string $lineType
     * @param \StructType\Quantity $quantity
     * @param string $fobId
     * @param \StructType\ToleranceDetails $toleranceDetails
     * @param bool $allowPartialShipments
     * @param float $unitPrice
     * @param float $lineItemTotal
     * @param string $requestedShipDate
     * @param string $requestedInHandsDate
     * @param string $referenceSalesQuote
     * @param \StructType\Program $program
     * @param string $endCustomerSalesOrder
     * @param string $productId
     * @param string $customerProductId
     * @param int $lineItemGroupingId
     * @param \ArrayType\PartArray $partArray
     * @param \StructType\Configuration $configuration
     */
    public function __construct($lineNumber = null, $lineReferenceId = null, $description = null, $lineType = null, \StructType\Quantity $quantity = null, $fobId = null, \StructType\ToleranceDetails $toleranceDetails = null, $allowPartialShipments = null, $unitPrice = null, $lineItemTotal = null, $requestedShipDate = null, $requestedInHandsDate = null, $referenceSalesQuote = null, \StructType\Program $program = null, $endCustomerSalesOrder = null, $productId = null, $customerProductId = null, $lineItemGroupingId = null, \ArrayType\PartArray $partArray = null, \StructType\Configuration $configuration = null)
    {
        $this
            ->setLineNumber($lineNumber)
            ->setLineReferenceId($lineReferenceId)
            ->setDescription($description)
            ->setLineType($lineType)
            ->setQuantity($quantity)
            ->setFobId($fobId)
            ->setToleranceDetails($toleranceDetails)
            ->setAllowPartialShipments($allowPartialShipments)
            ->setUnitPrice($unitPrice)
            ->setLineItemTotal($lineItemTotal)
            ->setRequestedShipDate($requestedShipDate)
            ->setRequestedInHandsDate($requestedInHandsDate)
            ->setReferenceSalesQuote($referenceSalesQuote)
            ->setProgram($program)
            ->setEndCustomerSalesOrder($endCustomerSalesOrder)
            ->setProductId($productId)
            ->setCustomerProductId($customerProductId)
            ->setLineItemGroupingId($lineItemGroupingId)
            ->setPartArray($partArray)
            ->setConfiguration($configuration);
    }
    /**
     * Get lineNumber value
     * @return int|null
     */
    public function getLineNumber()
    {
        return $this->lineNumber;
    }
    /**
     * Set lineNumber value
     * @param int $lineNumber
     * @return \StructType\LineItem
     */
    public function setLineNumber($lineNumber = null)
    {
        // validation for constraint: int
        if (!is_null($lineNumber) && !(is_int($lineNumber) || ctype_digit($lineNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lineNumber, true), gettype($lineNumber)), __LINE__);
        }
        $this->lineNumber = $lineNumber;
        return $this;
    }
    /**
     * Get lineReferenceId value
     * @return string|null
     */
    public function getLineReferenceId()
    {
        return $this->lineReferenceId;
    }
    /**
     * Set lineReferenceId value
     * @param string $lineReferenceId
     * @return \StructType\LineItem
     */
    public function setLineReferenceId($lineReferenceId = null)
    {
        // validation for constraint: string
        if (!is_null($lineReferenceId) && !is_string($lineReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lineReferenceId, true), gettype($lineReferenceId)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($lineReferenceId) && mb_strlen($lineReferenceId) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($lineReferenceId)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($lineReferenceId) && mb_strlen($lineReferenceId) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($lineReferenceId)), __LINE__);
        }
        $this->lineReferenceId = $lineReferenceId;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\LineItem
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get lineType value
     * @return string|null
     */
    public function getLineType()
    {
        return $this->lineType;
    }
    /**
     * Set lineType value
     * @param string $lineType
     * @return \StructType\LineItem
     */
    public function setLineType($lineType = null)
    {
        // validation for constraint: string
        if (!is_null($lineType) && !is_string($lineType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lineType, true), gettype($lineType)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($lineType) && mb_strlen($lineType) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($lineType)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($lineType) && mb_strlen($lineType) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($lineType)), __LINE__);
        }
        $this->lineType = $lineType;
        return $this;
    }
    /**
     * Get Quantity value
     * @return \StructType\Quantity|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param \StructType\Quantity $quantity
     * @return \StructType\LineItem
     */
    public function setQuantity(\StructType\Quantity $quantity = null)
    {
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get fobId value
     * @return string|null
     */
    public function getFobId()
    {
        return $this->fobId;
    }
    /**
     * Set fobId value
     * @param string $fobId
     * @return \StructType\LineItem
     */
    public function setFobId($fobId = null)
    {
        // validation for constraint: string
        if (!is_null($fobId) && !is_string($fobId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fobId, true), gettype($fobId)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($fobId) && mb_strlen($fobId) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($fobId)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($fobId) && mb_strlen($fobId) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($fobId)), __LINE__);
        }
        $this->fobId = $fobId;
        return $this;
    }
    /**
     * Get ToleranceDetails value
     * @return \StructType\ToleranceDetails|null
     */
    public function getToleranceDetails()
    {
        return $this->ToleranceDetails;
    }
    /**
     * Set ToleranceDetails value
     * @param \StructType\ToleranceDetails $toleranceDetails
     * @return \StructType\LineItem
     */
    public function setToleranceDetails(\StructType\ToleranceDetails $toleranceDetails = null)
    {
        $this->ToleranceDetails = $toleranceDetails;
        return $this;
    }
    /**
     * Get allowPartialShipments value
     * @return bool|null
     */
    public function getAllowPartialShipments()
    {
        return $this->allowPartialShipments;
    }
    /**
     * Set allowPartialShipments value
     * @param bool $allowPartialShipments
     * @return \StructType\LineItem
     */
    public function setAllowPartialShipments($allowPartialShipments = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowPartialShipments) && !is_bool($allowPartialShipments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowPartialShipments, true), gettype($allowPartialShipments)), __LINE__);
        }
        $this->allowPartialShipments = $allowPartialShipments;
        return $this;
    }
    /**
     * Get unitPrice value
     * @return float|null
     */
    public function getUnitPrice()
    {
        return $this->unitPrice;
    }
    /**
     * Set unitPrice value
     * @param float $unitPrice
     * @return \StructType\LineItem
     */
    public function setUnitPrice($unitPrice = null)
    {
        // validation for constraint: float
        if (!is_null($unitPrice) && !(is_float($unitPrice) || is_numeric($unitPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unitPrice, true), gettype($unitPrice)), __LINE__);
        }
        $this->unitPrice = $unitPrice;
        return $this;
    }
    /**
     * Get lineItemTotal value
     * @return float|null
     */
    public function getLineItemTotal()
    {
        return $this->lineItemTotal;
    }
    /**
     * Set lineItemTotal value
     * @param float $lineItemTotal
     * @return \StructType\LineItem
     */
    public function setLineItemTotal($lineItemTotal = null)
    {
        // validation for constraint: float
        if (!is_null($lineItemTotal) && !(is_float($lineItemTotal) || is_numeric($lineItemTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lineItemTotal, true), gettype($lineItemTotal)), __LINE__);
        }
        $this->lineItemTotal = $lineItemTotal;
        return $this;
    }
    /**
     * Get requestedShipDate value
     * @return string|null
     */
    public function getRequestedShipDate()
    {
        return $this->requestedShipDate;
    }
    /**
     * Set requestedShipDate value
     * @param string $requestedShipDate
     * @return \StructType\LineItem
     */
    public function setRequestedShipDate($requestedShipDate = null)
    {
        // validation for constraint: string
        if (!is_null($requestedShipDate) && !is_string($requestedShipDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestedShipDate, true), gettype($requestedShipDate)), __LINE__);
        }
        $this->requestedShipDate = $requestedShipDate;
        return $this;
    }
    /**
     * Get requestedInHandsDate value
     * @return string|null
     */
    public function getRequestedInHandsDate()
    {
        return $this->requestedInHandsDate;
    }
    /**
     * Set requestedInHandsDate value
     * @param string $requestedInHandsDate
     * @return \StructType\LineItem
     */
    public function setRequestedInHandsDate($requestedInHandsDate = null)
    {
        // validation for constraint: string
        if (!is_null($requestedInHandsDate) && !is_string($requestedInHandsDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestedInHandsDate, true), gettype($requestedInHandsDate)), __LINE__);
        }
        $this->requestedInHandsDate = $requestedInHandsDate;
        return $this;
    }
    /**
     * Get referenceSalesQuote value
     * @return string|null
     */
    public function getReferenceSalesQuote()
    {
        return $this->referenceSalesQuote;
    }
    /**
     * Set referenceSalesQuote value
     * @param string $referenceSalesQuote
     * @return \StructType\LineItem
     */
    public function setReferenceSalesQuote($referenceSalesQuote = null)
    {
        // validation for constraint: string
        if (!is_null($referenceSalesQuote) && !is_string($referenceSalesQuote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceSalesQuote, true), gettype($referenceSalesQuote)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($referenceSalesQuote) && mb_strlen($referenceSalesQuote) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($referenceSalesQuote)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($referenceSalesQuote) && mb_strlen($referenceSalesQuote) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($referenceSalesQuote)), __LINE__);
        }
        $this->referenceSalesQuote = $referenceSalesQuote;
        return $this;
    }
    /**
     * Get Program value
     * @return \StructType\Program|null
     */
    public function getProgram()
    {
        return $this->Program;
    }
    /**
     * Set Program value
     * @param \StructType\Program $program
     * @return \StructType\LineItem
     */
    public function setProgram(\StructType\Program $program = null)
    {
        $this->Program = $program;
        return $this;
    }
    /**
     * Get endCustomerSalesOrder value
     * @return string|null
     */
    public function getEndCustomerSalesOrder()
    {
        return $this->endCustomerSalesOrder;
    }
    /**
     * Set endCustomerSalesOrder value
     * @param string $endCustomerSalesOrder
     * @return \StructType\LineItem
     */
    public function setEndCustomerSalesOrder($endCustomerSalesOrder = null)
    {
        // validation for constraint: string
        if (!is_null($endCustomerSalesOrder) && !is_string($endCustomerSalesOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endCustomerSalesOrder, true), gettype($endCustomerSalesOrder)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($endCustomerSalesOrder) && mb_strlen($endCustomerSalesOrder) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($endCustomerSalesOrder)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($endCustomerSalesOrder) && mb_strlen($endCustomerSalesOrder) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($endCustomerSalesOrder)), __LINE__);
        }
        $this->endCustomerSalesOrder = $endCustomerSalesOrder;
        return $this;
    }
    /**
     * Get productId value
     * @return string|null
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param string $productId
     * @return \StructType\LineItem
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($productId) && mb_strlen($productId) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($productId)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($productId) && mb_strlen($productId) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Get customerProductId value
     * @return string|null
     */
    public function getCustomerProductId()
    {
        return $this->customerProductId;
    }
    /**
     * Set customerProductId value
     * @param string $customerProductId
     * @return \StructType\LineItem
     */
    public function setCustomerProductId($customerProductId = null)
    {
        // validation for constraint: string
        if (!is_null($customerProductId) && !is_string($customerProductId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerProductId, true), gettype($customerProductId)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($customerProductId) && mb_strlen($customerProductId) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($customerProductId)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($customerProductId) && mb_strlen($customerProductId) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($customerProductId)), __LINE__);
        }
        $this->customerProductId = $customerProductId;
        return $this;
    }
    /**
     * Get lineItemGroupingId value
     * @return int|null
     */
    public function getLineItemGroupingId()
    {
        return $this->lineItemGroupingId;
    }
    /**
     * Set lineItemGroupingId value
     * @param int $lineItemGroupingId
     * @return \StructType\LineItem
     */
    public function setLineItemGroupingId($lineItemGroupingId = null)
    {
        // validation for constraint: int
        if (!is_null($lineItemGroupingId) && !(is_int($lineItemGroupingId) || ctype_digit($lineItemGroupingId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lineItemGroupingId, true), gettype($lineItemGroupingId)), __LINE__);
        }
        $this->lineItemGroupingId = $lineItemGroupingId;
        return $this;
    }
    /**
     * Get PartArray value
     * @return \ArrayType\PartArray|null
     */
    public function getPartArray()
    {
        return $this->PartArray;
    }
    /**
     * Set PartArray value
     * @param \ArrayType\PartArray $partArray
     * @return \StructType\LineItem
     */
    public function setPartArray(\ArrayType\PartArray $partArray = null)
    {
        $this->PartArray = $partArray;
        return $this;
    }
    /**
     * Get Configuration value
     * @return \StructType\Configuration|null
     */
    public function getConfiguration()
    {
        return $this->Configuration;
    }
    /**
     * Set Configuration value
     * @param \StructType\Configuration $configuration
     * @return \StructType\LineItem
     */
    public function setConfiguration(\StructType\Configuration $configuration = null)
    {
        $this->Configuration = $configuration;
        return $this;
    }
}
