<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Layers StructType
 * @subpackage Structs
 */
class Layers extends AbstractStructBase
{
    /**
     * The colorSystem
     * Meta information extracted from the WSDL
     * - documentation: The color system to use
     * - base: ns2:ColorSystemType
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $colorSystem;
    /**
     * The LayerOrStopArray
     * @var \ArrayType\LayerOrStopArray
     */
    public $LayerOrStopArray;
    /**
     * Constructor method for Layers
     * @uses Layers::setColorSystem()
     * @uses Layers::setLayerOrStopArray()
     * @param string $colorSystem
     * @param \ArrayType\LayerOrStopArray $layerOrStopArray
     */
    public function __construct($colorSystem = null, \ArrayType\LayerOrStopArray $layerOrStopArray = null)
    {
        $this
            ->setColorSystem($colorSystem)
            ->setLayerOrStopArray($layerOrStopArray);
    }
    /**
     * Get colorSystem value
     * @return string|null
     */
    public function getColorSystem()
    {
        return $this->colorSystem;
    }
    /**
     * Set colorSystem value
     * @param string $colorSystem
     * @return \StructType\Layers
     */
    public function setColorSystem($colorSystem = null)
    {
        // validation for constraint: string
        if (!is_null($colorSystem) && !is_string($colorSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($colorSystem, true), gettype($colorSystem)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($colorSystem) && mb_strlen($colorSystem) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($colorSystem)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($colorSystem) && mb_strlen($colorSystem) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($colorSystem)), __LINE__);
        }
        $this->colorSystem = $colorSystem;
        return $this;
    }
    /**
     * Get LayerOrStopArray value
     * @return \ArrayType\LayerOrStopArray|null
     */
    public function getLayerOrStopArray()
    {
        return $this->LayerOrStopArray;
    }
    /**
     * Set LayerOrStopArray value
     * @param \ArrayType\LayerOrStopArray $layerOrStopArray
     * @return \StructType\Layers
     */
    public function setLayerOrStopArray(\ArrayType\LayerOrStopArray $layerOrStopArray = null)
    {
        $this->LayerOrStopArray = $layerOrStopArray;
        return $this;
    }
}
