<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LayerOrStop StructType
 * @subpackage Structs
 */
class LayerOrStop extends AbstractStructBase
{
    /**
     * The color
     * Meta information extracted from the WSDL
     * - documentation: The color value that corresponds to the colorSystem defined
     * - base: xsd:string
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $color;
    /**
     * The nameOrNumber
     * Meta information extracted from the WSDL
     * - documentation: The name or number of the layer/stop
     * - base: xsd:string
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $nameOrNumber;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - ref: ns2:description
     * @var string
     */
    public $description;
    /**
     * Constructor method for LayerOrStop
     * @uses LayerOrStop::setColor()
     * @uses LayerOrStop::setNameOrNumber()
     * @uses LayerOrStop::setDescription()
     * @param string $color
     * @param string $nameOrNumber
     * @param string $description
     */
    public function __construct($color = null, $nameOrNumber = null, $description = null)
    {
        $this
            ->setColor($color)
            ->setNameOrNumber($nameOrNumber)
            ->setDescription($description);
    }
    /**
     * Get color value
     * @return string|null
     */
    public function getColor()
    {
        return $this->color;
    }
    /**
     * Set color value
     * @param string $color
     * @return \StructType\LayerOrStop
     */
    public function setColor($color = null)
    {
        // validation for constraint: string
        if (!is_null($color) && !is_string($color)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($color, true), gettype($color)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($color) && mb_strlen($color) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($color)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($color) && mb_strlen($color) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($color)), __LINE__);
        }
        $this->color = $color;
        return $this;
    }
    /**
     * Get nameOrNumber value
     * @return string|null
     */
    public function getNameOrNumber()
    {
        return $this->nameOrNumber;
    }
    /**
     * Set nameOrNumber value
     * @param string $nameOrNumber
     * @return \StructType\LayerOrStop
     */
    public function setNameOrNumber($nameOrNumber = null)
    {
        // validation for constraint: string
        if (!is_null($nameOrNumber) && !is_string($nameOrNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameOrNumber, true), gettype($nameOrNumber)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($nameOrNumber) && mb_strlen($nameOrNumber) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($nameOrNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($nameOrNumber) && mb_strlen($nameOrNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($nameOrNumber)), __LINE__);
        }
        $this->nameOrNumber = $nameOrNumber;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\LayerOrStop
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
}
