<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSupportedOrderTypesResponse StructType
 * @subpackage Structs
 */
class GetSupportedOrderTypesResponse extends AbstractStructBase
{
    /**
     * The supportedOrderTypes
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $supportedOrderTypes;
    /**
     * The ServiceMessageArray
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns3:ServiceMessageArray
     * @var \ArrayType\ServiceMessageArray
     */
    public $ServiceMessageArray;
    /**
     * Constructor method for GetSupportedOrderTypesResponse
     * @uses GetSupportedOrderTypesResponse::setSupportedOrderTypes()
     * @uses GetSupportedOrderTypesResponse::setServiceMessageArray()
     * @param string[] $supportedOrderTypes
     * @param \ArrayType\ServiceMessageArray $serviceMessageArray
     */
    public function __construct(array $supportedOrderTypes = array(), \ArrayType\ServiceMessageArray $serviceMessageArray = null)
    {
        $this
            ->setSupportedOrderTypes($supportedOrderTypes)
            ->setServiceMessageArray($serviceMessageArray);
    }
    /**
     * Get supportedOrderTypes value
     * @return string[]|null
     */
    public function getSupportedOrderTypes()
    {
        return $this->supportedOrderTypes;
    }
    /**
     * This method is responsible for validating the values passed to the setSupportedOrderTypes method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupportedOrderTypes method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupportedOrderTypesForArrayConstraintsFromSetSupportedOrderTypes(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getSupportedOrderTypesResponseSupportedOrderTypesItem) {
            // validation for constraint: enumeration
            if (!\EnumType\OrderTypeType::valueIsValid($getSupportedOrderTypesResponseSupportedOrderTypesItem)) {
                $invalidValues[] = is_object($getSupportedOrderTypesResponseSupportedOrderTypesItem) ? get_class($getSupportedOrderTypesResponseSupportedOrderTypesItem) : sprintf('%s(%s)', gettype($getSupportedOrderTypesResponseSupportedOrderTypesItem), var_export($getSupportedOrderTypesResponseSupportedOrderTypesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\OrderTypeType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\OrderTypeType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set supportedOrderTypes value
     * @uses \EnumType\OrderTypeType::valueIsValid()
     * @uses \EnumType\OrderTypeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $supportedOrderTypes
     * @return \StructType\GetSupportedOrderTypesResponse
     */
    public function setSupportedOrderTypes(array $supportedOrderTypes = array())
    {
        // validation for constraint: array
        if ('' !== ($supportedOrderTypesArrayErrorMessage = self::validateSupportedOrderTypesForArrayConstraintsFromSetSupportedOrderTypes($supportedOrderTypes))) {
            throw new \InvalidArgumentException($supportedOrderTypesArrayErrorMessage, __LINE__);
        }
        $this->supportedOrderTypes = $supportedOrderTypes;
        return $this;
    }
    /**
     * Add item to supportedOrderTypes value
     * @uses \EnumType\OrderTypeType::valueIsValid()
     * @uses \EnumType\OrderTypeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\GetSupportedOrderTypesResponse
     */
    public function addToSupportedOrderTypes($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OrderTypeType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\OrderTypeType', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\OrderTypeType::getValidValues())), __LINE__);
        }
        $this->supportedOrderTypes[] = $item;
        return $this;
    }
    /**
     * Get ServiceMessageArray value
     * @return \ArrayType\ServiceMessageArray|null
     */
    public function getServiceMessageArray()
    {
        return $this->ServiceMessageArray;
    }
    /**
     * Set ServiceMessageArray value
     * @param \ArrayType\ServiceMessageArray $serviceMessageArray
     * @return \StructType\GetSupportedOrderTypesResponse
     */
    public function setServiceMessageArray(\ArrayType\ServiceMessageArray $serviceMessageArray = null)
    {
        $this->ServiceMessageArray = $serviceMessageArray;
        return $this;
    }
}
