<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Dimensions StructType
 * @subpackage Structs
 */
class Dimensions extends AbstractStructBase
{
    /**
     * The diameter
     * Meta information extracted from the WSDL
     * - documentation: The diameter
     * - base: xsd:decimal
     * - fractionDigits: 4
     * - minOccurs: 0
     * - ref: ns2:diameter
     * @var float
     */
    public $diameter;
    /**
     * The height
     * Meta information extracted from the WSDL
     * - documentation: The height
     * - base: xsd:decimal
     * - fractionDigits: 4
     * - minOccurs: 0
     * - ref: ns2:height
     * @var float
     */
    public $height;
    /**
     * The uom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns2:uom
     * @var string
     */
    public $uom;
    /**
     * The width
     * Meta information extracted from the WSDL
     * - documentation: The width
     * - base: xsd:decimal
     * - fractionDigits: 4
     * - minOccurs: 0
     * - ref: ns2:width
     * @var float
     */
    public $width;
    /**
     * The useMaxLocationDimensions
     * @var bool
     */
    public $useMaxLocationDimensions;
    /**
     * The geometry
     * Meta information extracted from the WSDL
     * - documentation: The decoration geometry
     * - base: ns2:GeometryType
     * - maxLength: 64
     * - minLength: 1
     * - ref: ns2:geometry
     * @var string
     */
    public $geometry;
    /**
     * Constructor method for Dimensions
     * @uses Dimensions::setDiameter()
     * @uses Dimensions::setHeight()
     * @uses Dimensions::setUom()
     * @uses Dimensions::setWidth()
     * @uses Dimensions::setUseMaxLocationDimensions()
     * @uses Dimensions::setGeometry()
     * @param float $diameter
     * @param float $height
     * @param string $uom
     * @param float $width
     * @param bool $useMaxLocationDimensions
     * @param string $geometry
     */
    public function __construct($diameter = null, $height = null, $uom = null, $width = null, $useMaxLocationDimensions = null, $geometry = null)
    {
        $this
            ->setDiameter($diameter)
            ->setHeight($height)
            ->setUom($uom)
            ->setWidth($width)
            ->setUseMaxLocationDimensions($useMaxLocationDimensions)
            ->setGeometry($geometry);
    }
    /**
     * Get diameter value
     * @return float|null
     */
    public function getDiameter()
    {
        return $this->diameter;
    }
    /**
     * Set diameter value
     * @param float $diameter
     * @return \StructType\Dimensions
     */
    public function setDiameter($diameter = null)
    {
        // validation for constraint: float
        if (!is_null($diameter) && !(is_float($diameter) || is_numeric($diameter))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($diameter, true), gettype($diameter)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($diameter) && mb_strlen(mb_substr($diameter, false !== mb_strpos($diameter, '.') ? mb_strpos($diameter, '.') + 1 : mb_strlen($diameter))) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($diameter, true), mb_strlen(mb_substr($diameter, mb_strpos($diameter, '.') + 1))), __LINE__);
        }
        $this->diameter = $diameter;
        return $this;
    }
    /**
     * Get height value
     * @return float|null
     */
    public function getHeight()
    {
        return $this->height;
    }
    /**
     * Set height value
     * @param float $height
     * @return \StructType\Dimensions
     */
    public function setHeight($height = null)
    {
        // validation for constraint: float
        if (!is_null($height) && !(is_float($height) || is_numeric($height))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($height, true), gettype($height)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($height) && mb_strlen(mb_substr($height, false !== mb_strpos($height, '.') ? mb_strpos($height, '.') + 1 : mb_strlen($height))) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($height, true), mb_strlen(mb_substr($height, mb_strpos($height, '.') + 1))), __LINE__);
        }
        $this->height = $height;
        return $this;
    }
    /**
     * Get uom value
     * @return string|null
     */
    public function getUom()
    {
        return $this->uom;
    }
    /**
     * Set uom value
     * @uses \EnumType\ISO20022UomCode::valueIsValid()
     * @uses \EnumType\ISO20022UomCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $uom
     * @return \StructType\Dimensions
     */
    public function setUom($uom = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ISO20022UomCode::valueIsValid($uom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ISO20022UomCode', is_array($uom) ? implode(', ', $uom) : var_export($uom, true), implode(', ', \EnumType\ISO20022UomCode::getValidValues())), __LINE__);
        }
        $this->uom = $uom;
        return $this;
    }
    /**
     * Get width value
     * @return float|null
     */
    public function getWidth()
    {
        return $this->width;
    }
    /**
     * Set width value
     * @param float $width
     * @return \StructType\Dimensions
     */
    public function setWidth($width = null)
    {
        // validation for constraint: float
        if (!is_null($width) && !(is_float($width) || is_numeric($width))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($width, true), gettype($width)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($width) && mb_strlen(mb_substr($width, false !== mb_strpos($width, '.') ? mb_strpos($width, '.') + 1 : mb_strlen($width))) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($width, true), mb_strlen(mb_substr($width, mb_strpos($width, '.') + 1))), __LINE__);
        }
        $this->width = $width;
        return $this;
    }
    /**
     * Get useMaxLocationDimensions value
     * @return bool|null
     */
    public function getUseMaxLocationDimensions()
    {
        return $this->useMaxLocationDimensions;
    }
    /**
     * Set useMaxLocationDimensions value
     * @param bool $useMaxLocationDimensions
     * @return \StructType\Dimensions
     */
    public function setUseMaxLocationDimensions($useMaxLocationDimensions = null)
    {
        // validation for constraint: boolean
        if (!is_null($useMaxLocationDimensions) && !is_bool($useMaxLocationDimensions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useMaxLocationDimensions, true), gettype($useMaxLocationDimensions)), __LINE__);
        }
        $this->useMaxLocationDimensions = $useMaxLocationDimensions;
        return $this;
    }
    /**
     * Get geometry value
     * @return string|null
     */
    public function getGeometry()
    {
        return $this->geometry;
    }
    /**
     * Set geometry value
     * @param string $geometry
     * @return \StructType\Dimensions
     */
    public function setGeometry($geometry = null)
    {
        // validation for constraint: string
        if (!is_null($geometry) && !is_string($geometry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($geometry, true), gettype($geometry)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($geometry) && mb_strlen($geometry) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($geometry)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($geometry) && mb_strlen($geometry) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($geometry)), __LINE__);
        }
        $this->geometry = $geometry;
        return $this;
    }
}
