<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Decoration StructType
 * Meta information extracted from the WSDL
 * - documentation: The object containing the details of the artwork
 * @subpackage Structs
 */
class Decoration extends AbstractStructBase
{
    /**
     * The decorationName
     * Meta information extracted from the WSDL
     * - documentation: The decoration name
     * - base: xsd:string
     * - maxLength: 128
     * - minLength: 1
     * - minOccurs: 0
     * - ref: ns2:decorationName
     * @var string
     */
    public $decorationName;
    /**
     * The Artwork
     * Meta information extracted from the WSDL
     * - ref: ns2:Artwork
     * @var \StructType\Artwork
     */
    public $Artwork;
    /**
     * The decorationId
     * Meta information extracted from the WSDL
     * - ref: ns2:decorationId
     * @var int
     */
    public $decorationId;
    /**
     * Constructor method for Decoration
     * @uses Decoration::setDecorationName()
     * @uses Decoration::setArtwork()
     * @uses Decoration::setDecorationId()
     * @param string $decorationName
     * @param \StructType\Artwork $artwork
     * @param int $decorationId
     */
    public function __construct($decorationName = null, \StructType\Artwork $artwork = null, $decorationId = null)
    {
        $this
            ->setDecorationName($decorationName)
            ->setArtwork($artwork)
            ->setDecorationId($decorationId);
    }
    /**
     * Get decorationName value
     * @return string|null
     */
    public function getDecorationName()
    {
        return $this->decorationName;
    }
    /**
     * Set decorationName value
     * @param string $decorationName
     * @return \StructType\Decoration
     */
    public function setDecorationName($decorationName = null)
    {
        // validation for constraint: string
        if (!is_null($decorationName) && !is_string($decorationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($decorationName, true), gettype($decorationName)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($decorationName) && mb_strlen($decorationName) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($decorationName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($decorationName) && mb_strlen($decorationName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($decorationName)), __LINE__);
        }
        $this->decorationName = $decorationName;
        return $this;
    }
    /**
     * Get Artwork value
     * @return \StructType\Artwork|null
     */
    public function getArtwork()
    {
        return $this->Artwork;
    }
    /**
     * Set Artwork value
     * @param \StructType\Artwork $artwork
     * @return \StructType\Decoration
     */
    public function setArtwork(\StructType\Artwork $artwork = null)
    {
        $this->Artwork = $artwork;
        return $this;
    }
    /**
     * Get decorationId value
     * @return int|null
     */
    public function getDecorationId()
    {
        return $this->decorationId;
    }
    /**
     * Set decorationId value
     * @param int $decorationId
     * @return \StructType\Decoration
     */
    public function setDecorationId($decorationId = null)
    {
        // validation for constraint: int
        if (!is_null($decorationId) && !(is_int($decorationId) || ctype_digit($decorationId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($decorationId, true), gettype($decorationId)), __LINE__);
        }
        $this->decorationId = $decorationId;
        return $this;
    }
}
