<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ToleranceType EnumType
 * Meta information extracted from the WSDL
 * - documentation: The type of tolerance allowed
 * @subpackage Enumerations
 */
class ToleranceType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'AllowOverrun'
     * @return string 'AllowOverrun'
     */
    const VALUE_ALLOW_OVERRUN = 'AllowOverrun';
    /**
     * Constant for value 'AllowUnderrun'
     * @return string 'AllowUnderrun'
     */
    const VALUE_ALLOW_UNDERRUN = 'AllowUnderrun';
    /**
     * Constant for value 'AllowOverrunOrUnderrun'
     * @return string 'AllowOverrunOrUnderrun'
     */
    const VALUE_ALLOW_OVERRUN_OR_UNDERRUN = 'AllowOverrunOrUnderrun';
    /**
     * Constant for value 'ExactOnly'
     * @return string 'ExactOnly'
     */
    const VALUE_EXACT_ONLY = 'ExactOnly';
    /**
     * Return allowed values
     * @uses self::VALUE_ALLOW_OVERRUN
     * @uses self::VALUE_ALLOW_UNDERRUN
     * @uses self::VALUE_ALLOW_OVERRUN_OR_UNDERRUN
     * @uses self::VALUE_EXACT_ONLY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALLOW_OVERRUN,
            self::VALUE_ALLOW_UNDERRUN,
            self::VALUE_ALLOW_OVERRUN_OR_UNDERRUN,
            self::VALUE_EXACT_ONLY,
        );
    }
}
