<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for TaxTypeType EnumType
 * Meta information extracted from the WSDL
 * - documentation: The type of tax
 * @subpackage Enumerations
 */
class TaxTypeType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Hst-Gst'
     * @return string 'Hst-Gst'
     */
    const VALUE_HST_GST = 'Hst-Gst';
    /**
     * Constant for value 'Pst'
     * @return string 'Pst'
     */
    const VALUE_PST = 'Pst';
    /**
     * Constant for value 'SalesTax'
     * @return string 'SalesTax'
     */
    const VALUE_SALES_TAX = 'SalesTax';
    /**
     * Return allowed values
     * @uses self::VALUE_HST_GST
     * @uses self::VALUE_PST
     * @uses self::VALUE_SALES_TAX
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_HST_GST,
            self::VALUE_PST,
            self::VALUE_SALES_TAX,
        );
    }
}
