<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ChargeTypeType EnumType
 * Meta information extracted from the WSDL
 * - documentation: The type of charge
 * @subpackage Enumerations
 */
class ChargeTypeType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Freight'
     * @return string 'Freight'
     */
    const VALUE_FREIGHT = 'Freight';
    /**
     * Constant for value 'Order'
     * @return string 'Order'
     */
    const VALUE_ORDER = 'Order';
    /**
     * Constant for value 'Run'
     * @return string 'Run'
     */
    const VALUE_RUN = 'Run';
    /**
     * Constant for value 'Setup'
     * @return string 'Setup'
     */
    const VALUE_SETUP = 'Setup';
    /**
     * Return allowed values
     * @uses self::VALUE_FREIGHT
     * @uses self::VALUE_ORDER
     * @uses self::VALUE_RUN
     * @uses self::VALUE_SETUP
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FREIGHT,
            self::VALUE_ORDER,
            self::VALUE_RUN,
            self::VALUE_SETUP,
        );
    }
}
