<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for TypesetArray ArrayType
 * @subpackage Arrays
 */
class TypesetArray extends AbstractStructArrayBase
{
    /**
     * The Typeset
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ns2:Typeset
     * @var \StructType\Typeset[]
     */
    public $Typeset;
    /**
     * Constructor method for TypesetArray
     * @uses TypesetArray::setTypeset()
     * @param \StructType\Typeset[] $typeset
     */
    public function __construct(array $typeset = array())
    {
        $this
            ->setTypeset($typeset);
    }
    /**
     * Get Typeset value
     * @return \StructType\Typeset[]|null
     */
    public function getTypeset()
    {
        return $this->Typeset;
    }
    /**
     * This method is responsible for validating the values passed to the setTypeset method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTypeset method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTypesetForArrayConstraintsFromSetTypeset(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $typesetArrayTypesetItem) {
            // validation for constraint: itemType
            if (!$typesetArrayTypesetItem instanceof \StructType\Typeset) {
                $invalidValues[] = is_object($typesetArrayTypesetItem) ? get_class($typesetArrayTypesetItem) : sprintf('%s(%s)', gettype($typesetArrayTypesetItem), var_export($typesetArrayTypesetItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Typeset property can only contain items of type \StructType\Typeset, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Typeset value
     * @throws \InvalidArgumentException
     * @param \StructType\Typeset[] $typeset
     * @return \ArrayType\TypesetArray
     */
    public function setTypeset(array $typeset = array())
    {
        // validation for constraint: array
        if ('' !== ($typesetArrayErrorMessage = self::validateTypesetForArrayConstraintsFromSetTypeset($typeset))) {
            throw new \InvalidArgumentException($typesetArrayErrorMessage, __LINE__);
        }
        $this->Typeset = $typeset;
        return $this;
    }
    /**
     * Add item to Typeset value
     * @throws \InvalidArgumentException
     * @param \StructType\Typeset $item
     * @return \ArrayType\TypesetArray
     */
    public function addToTypeset(\StructType\Typeset $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Typeset) {
            throw new \InvalidArgumentException(sprintf('The Typeset property can only contain items of type \StructType\Typeset, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Typeset[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Typeset|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Typeset|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Typeset|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Typeset|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Typeset|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Typeset
     */
    public function getAttributeName()
    {
        return 'Typeset';
    }
}
