<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ShipmentArray ArrayType
 * Meta information extracted from the WSDL
 * - documentation: Any array of purchase order shipments
 * @subpackage Arrays
 */
class ShipmentArray extends AbstractStructArrayBase
{
    /**
     * The Shipment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ns3:Shipment
     * @var \StructType\Shipment[]
     */
    public $Shipment;
    /**
     * Constructor method for ShipmentArray
     * @uses ShipmentArray::setShipment()
     * @param \StructType\Shipment[] $shipment
     */
    public function __construct(array $shipment = array())
    {
        $this
            ->setShipment($shipment);
    }
    /**
     * Get Shipment value
     * @return \StructType\Shipment[]|null
     */
    public function getShipment()
    {
        return $this->Shipment;
    }
    /**
     * This method is responsible for validating the values passed to the setShipment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentForArrayConstraintsFromSetShipment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentArrayShipmentItem) {
            // validation for constraint: itemType
            if (!$shipmentArrayShipmentItem instanceof \StructType\Shipment) {
                $invalidValues[] = is_object($shipmentArrayShipmentItem) ? get_class($shipmentArrayShipmentItem) : sprintf('%s(%s)', gettype($shipmentArrayShipmentItem), var_export($shipmentArrayShipmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Shipment property can only contain items of type \StructType\Shipment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Shipment value
     * @throws \InvalidArgumentException
     * @param \StructType\Shipment[] $shipment
     * @return \ArrayType\ShipmentArray
     */
    public function setShipment(array $shipment = array())
    {
        // validation for constraint: array
        if ('' !== ($shipmentArrayErrorMessage = self::validateShipmentForArrayConstraintsFromSetShipment($shipment))) {
            throw new \InvalidArgumentException($shipmentArrayErrorMessage, __LINE__);
        }
        $this->Shipment = $shipment;
        return $this;
    }
    /**
     * Add item to Shipment value
     * @throws \InvalidArgumentException
     * @param \StructType\Shipment $item
     * @return \ArrayType\ShipmentArray
     */
    public function addToShipment(\StructType\Shipment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Shipment) {
            throw new \InvalidArgumentException(sprintf('The Shipment property can only contain items of type \StructType\Shipment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Shipment[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Shipment|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Shipment|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Shipment|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Shipment|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Shipment|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Shipment
     */
    public function getAttributeName()
    {
        return 'Shipment';
    }
}
