<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for LineItemArray ArrayType
 * Meta information extracted from the WSDL
 * - documentation: An array of purchase order line items
 * @subpackage Arrays
 */
class LineItemArray extends AbstractStructArrayBase
{
    /**
     * The LineItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ns1:LineItem
     * @var \StructType\LineItem[]
     */
    public $LineItem;
    /**
     * Constructor method for LineItemArray
     * @uses LineItemArray::setLineItem()
     * @param \StructType\LineItem[] $lineItem
     */
    public function __construct(array $lineItem = array())
    {
        $this
            ->setLineItem($lineItem);
    }
    /**
     * Get LineItem value
     * @return \StructType\LineItem[]|null
     */
    public function getLineItem()
    {
        return $this->LineItem;
    }
    /**
     * This method is responsible for validating the values passed to the setLineItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLineItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLineItemForArrayConstraintsFromSetLineItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $lineItemArrayLineItemItem) {
            // validation for constraint: itemType
            if (!$lineItemArrayLineItemItem instanceof \StructType\LineItem) {
                $invalidValues[] = is_object($lineItemArrayLineItemItem) ? get_class($lineItemArrayLineItemItem) : sprintf('%s(%s)', gettype($lineItemArrayLineItemItem), var_export($lineItemArrayLineItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LineItem property can only contain items of type \StructType\LineItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LineItem value
     * @throws \InvalidArgumentException
     * @param \StructType\LineItem[] $lineItem
     * @return \ArrayType\LineItemArray
     */
    public function setLineItem(array $lineItem = array())
    {
        // validation for constraint: array
        if ('' !== ($lineItemArrayErrorMessage = self::validateLineItemForArrayConstraintsFromSetLineItem($lineItem))) {
            throw new \InvalidArgumentException($lineItemArrayErrorMessage, __LINE__);
        }
        $this->LineItem = $lineItem;
        return $this;
    }
    /**
     * Add item to LineItem value
     * @throws \InvalidArgumentException
     * @param \StructType\LineItem $item
     * @return \ArrayType\LineItemArray
     */
    public function addToLineItem(\StructType\LineItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LineItem) {
            throw new \InvalidArgumentException(sprintf('The LineItem property can only contain items of type \StructType\LineItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LineItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\LineItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\LineItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\LineItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\LineItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\LineItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string LineItem
     */
    public function getAttributeName()
    {
        return 'LineItem';
    }
}
