<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for LayerOrStopArray ArrayType
 * Meta information extracted from the WSDL
 * - documentation: An array of layers for the artwork
 * @subpackage Arrays
 */
class LayerOrStopArray extends AbstractStructArrayBase
{
    /**
     * The LayerOrStop
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ns2:LayerOrStop
     * @var \StructType\LayerOrStop[]
     */
    public $LayerOrStop;
    /**
     * Constructor method for LayerOrStopArray
     * @uses LayerOrStopArray::setLayerOrStop()
     * @param \StructType\LayerOrStop[] $layerOrStop
     */
    public function __construct(array $layerOrStop = array())
    {
        $this
            ->setLayerOrStop($layerOrStop);
    }
    /**
     * Get LayerOrStop value
     * @return \StructType\LayerOrStop[]|null
     */
    public function getLayerOrStop()
    {
        return $this->LayerOrStop;
    }
    /**
     * This method is responsible for validating the values passed to the setLayerOrStop method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLayerOrStop method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLayerOrStopForArrayConstraintsFromSetLayerOrStop(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $layerOrStopArrayLayerOrStopItem) {
            // validation for constraint: itemType
            if (!$layerOrStopArrayLayerOrStopItem instanceof \StructType\LayerOrStop) {
                $invalidValues[] = is_object($layerOrStopArrayLayerOrStopItem) ? get_class($layerOrStopArrayLayerOrStopItem) : sprintf('%s(%s)', gettype($layerOrStopArrayLayerOrStopItem), var_export($layerOrStopArrayLayerOrStopItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LayerOrStop property can only contain items of type \StructType\LayerOrStop, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LayerOrStop value
     * @throws \InvalidArgumentException
     * @param \StructType\LayerOrStop[] $layerOrStop
     * @return \ArrayType\LayerOrStopArray
     */
    public function setLayerOrStop(array $layerOrStop = array())
    {
        // validation for constraint: array
        if ('' !== ($layerOrStopArrayErrorMessage = self::validateLayerOrStopForArrayConstraintsFromSetLayerOrStop($layerOrStop))) {
            throw new \InvalidArgumentException($layerOrStopArrayErrorMessage, __LINE__);
        }
        $this->LayerOrStop = $layerOrStop;
        return $this;
    }
    /**
     * Add item to LayerOrStop value
     * @throws \InvalidArgumentException
     * @param \StructType\LayerOrStop $item
     * @return \ArrayType\LayerOrStopArray
     */
    public function addToLayerOrStop(\StructType\LayerOrStop $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LayerOrStop) {
            throw new \InvalidArgumentException(sprintf('The LayerOrStop property can only contain items of type \StructType\LayerOrStop, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LayerOrStop[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\LayerOrStop|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\LayerOrStop|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\LayerOrStop|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\LayerOrStop|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\LayerOrStop|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string LayerOrStop
     */
    public function getAttributeName()
    {
        return 'LayerOrStop';
    }
}
