<?php

namespace RecruitCrm\LogicMelon\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for PeoplEdTag EnumType
 * @subpackage Enumerations
 */
class PeoplEdTag extends AbstractStructEnumBase
{
    /**
     * Constant for value 'PeoplEdNotReviewed'
     * @return string 'PeoplEdNotReviewed'
     */
    const VALUE_PEOPL_ED_NOT_REVIEWED = 'PeoplEdNotReviewed';
    /**
     * Constant for value 'PeoplEdAccepted'
     * @return string 'PeoplEdAccepted'
     */
    const VALUE_PEOPL_ED_ACCEPTED = 'PeoplEdAccepted';
    /**
     * Constant for value 'PeoplEdRejected'
     * @return string 'PeoplEdRejected'
     */
    const VALUE_PEOPL_ED_REJECTED = 'PeoplEdRejected';
    /**
     * Constant for value 'PeoplEdSubscribed'
     * @return string 'PeoplEdSubscribed'
     */
    const VALUE_PEOPL_ED_SUBSCRIBED = 'PeoplEdSubscribed';
    /**
     * Constant for value 'PeoplEdBarred'
     * @return string 'PeoplEdBarred'
     */
    const VALUE_PEOPL_ED_BARRED = 'PeoplEdBarred';
    /**
     * Return allowed values
     * @uses self::VALUE_PEOPL_ED_NOT_REVIEWED
     * @uses self::VALUE_PEOPL_ED_ACCEPTED
     * @uses self::VALUE_PEOPL_ED_REJECTED
     * @uses self::VALUE_PEOPL_ED_SUBSCRIBED
     * @uses self::VALUE_PEOPL_ED_BARRED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PEOPL_ED_NOT_REVIEWED,
            self::VALUE_PEOPL_ED_ACCEPTED,
            self::VALUE_PEOPL_ED_REJECTED,
            self::VALUE_PEOPL_ED_SUBSCRIBED,
            self::VALUE_PEOPL_ED_BARRED,
        );
    }
}
