<?php

namespace RecruitCrm\LogicMelon\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for APIAdvertWithPostingsPaged StructType
 * @subpackage Structs
 */
class APIAdvertWithPostingsPaged extends AbstractStructBase
{
    /**
     * The PageCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PageCount;
    /**
     * The PageIndex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PageIndex;
    /**
     * The TotalItemCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TotalItemCount;
    /**
     * The AdvertWithPostings
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \RecruitCrm\LogicMelon\ArrayType\ArrayOfAPIAdvertWithPostings
     */
    public $AdvertWithPostings;
    /**
     * Constructor method for APIAdvertWithPostingsPaged
     * @uses APIAdvertWithPostingsPaged::setPageCount()
     * @uses APIAdvertWithPostingsPaged::setPageIndex()
     * @uses APIAdvertWithPostingsPaged::setTotalItemCount()
     * @uses APIAdvertWithPostingsPaged::setAdvertWithPostings()
     * @param int $pageCount
     * @param int $pageIndex
     * @param int $totalItemCount
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfAPIAdvertWithPostings $advertWithPostings
     */
    public function __construct($pageCount = null, $pageIndex = null, $totalItemCount = null, \RecruitCrm\LogicMelon\ArrayType\ArrayOfAPIAdvertWithPostings $advertWithPostings = null)
    {
        $this
            ->setPageCount($pageCount)
            ->setPageIndex($pageIndex)
            ->setTotalItemCount($totalItemCount)
            ->setAdvertWithPostings($advertWithPostings);
    }
    /**
     * Get PageCount value
     * @return int
     */
    public function getPageCount()
    {
        return $this->PageCount;
    }
    /**
     * Set PageCount value
     * @param int $pageCount
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvertWithPostingsPaged
     */
    public function setPageCount($pageCount = null)
    {
        // validation for constraint: int
        if (!is_null($pageCount) && !(is_int($pageCount) || ctype_digit($pageCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageCount, true), gettype($pageCount)), __LINE__);
        }
        $this->PageCount = $pageCount;
        return $this;
    }
    /**
     * Get PageIndex value
     * @return int
     */
    public function getPageIndex()
    {
        return $this->PageIndex;
    }
    /**
     * Set PageIndex value
     * @param int $pageIndex
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvertWithPostingsPaged
     */
    public function setPageIndex($pageIndex = null)
    {
        // validation for constraint: int
        if (!is_null($pageIndex) && !(is_int($pageIndex) || ctype_digit($pageIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageIndex, true), gettype($pageIndex)), __LINE__);
        }
        $this->PageIndex = $pageIndex;
        return $this;
    }
    /**
     * Get TotalItemCount value
     * @return int
     */
    public function getTotalItemCount()
    {
        return $this->TotalItemCount;
    }
    /**
     * Set TotalItemCount value
     * @param int $totalItemCount
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvertWithPostingsPaged
     */
    public function setTotalItemCount($totalItemCount = null)
    {
        // validation for constraint: int
        if (!is_null($totalItemCount) && !(is_int($totalItemCount) || ctype_digit($totalItemCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalItemCount, true), gettype($totalItemCount)), __LINE__);
        }
        $this->TotalItemCount = $totalItemCount;
        return $this;
    }
    /**
     * Get AdvertWithPostings value
     * @return \RecruitCrm\LogicMelon\ArrayType\ArrayOfAPIAdvertWithPostings|null
     */
    public function getAdvertWithPostings()
    {
        return $this->AdvertWithPostings;
    }
    /**
     * Set AdvertWithPostings value
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfAPIAdvertWithPostings $advertWithPostings
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvertWithPostingsPaged
     */
    public function setAdvertWithPostings(\RecruitCrm\LogicMelon\ArrayType\ArrayOfAPIAdvertWithPostings $advertWithPostings = null)
    {
        $this->AdvertWithPostings = $advertWithPostings;
        return $this;
    }
}
