<?php

namespace RecruitCrm\LogicMelon\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfGetValue ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfGetValue
 * @subpackage Arrays
 */
class ArrayOfGetValue extends AbstractStructArrayBase
{
    /**
     * The GetValue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \RecruitCrm\LogicMelon\StructType\GetValue[]
     */
    public $GetValue;
    /**
     * Constructor method for ArrayOfGetValue
     * @uses ArrayOfGetValue::setGetValue()
     * @param \RecruitCrm\LogicMelon\StructType\GetValue[] $getValue
     */
    public function __construct(array $getValue = array())
    {
        $this
            ->setGetValue($getValue);
    }
    /**
     * Get GetValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RecruitCrm\LogicMelon\StructType\GetValue[]|null
     */
    public function getGetValue()
    {
        return isset($this->GetValue) ? $this->GetValue : null;
    }
    /**
     * This method is responsible for validating the values passed to the setGetValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGetValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGetValueForArrayConstraintsFromSetGetValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfGetValueGetValueItem) {
            // validation for constraint: itemType
            if (!$arrayOfGetValueGetValueItem instanceof \RecruitCrm\LogicMelon\StructType\GetValue) {
                $invalidValues[] = is_object($arrayOfGetValueGetValueItem) ? get_class($arrayOfGetValueGetValueItem) : sprintf('%s(%s)', gettype($arrayOfGetValueGetValueItem), var_export($arrayOfGetValueGetValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GetValue property can only contain items of type \RecruitCrm\LogicMelon\StructType\GetValue, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GetValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \RecruitCrm\LogicMelon\StructType\GetValue[] $getValue
     * @return \RecruitCrm\LogicMelon\ArrayType\ArrayOfGetValue
     */
    public function setGetValue(array $getValue = array())
    {
        // validation for constraint: array
        if ('' !== ($getValueArrayErrorMessage = self::validateGetValueForArrayConstraintsFromSetGetValue($getValue))) {
            throw new \InvalidArgumentException($getValueArrayErrorMessage, __LINE__);
        }
        if (is_null($getValue) || (is_array($getValue) && empty($getValue))) {
            unset($this->GetValue);
        } else {
            $this->GetValue = $getValue;
        }
        return $this;
    }
    /**
     * Add item to GetValue value
     * @throws \InvalidArgumentException
     * @param \RecruitCrm\LogicMelon\StructType\GetValue $item
     * @return \RecruitCrm\LogicMelon\ArrayType\ArrayOfGetValue
     */
    public function addToGetValue(\RecruitCrm\LogicMelon\StructType\GetValue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \RecruitCrm\LogicMelon\StructType\GetValue) {
            throw new \InvalidArgumentException(sprintf('The GetValue property can only contain items of type \RecruitCrm\LogicMelon\StructType\GetValue, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GetValue[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \RecruitCrm\LogicMelon\StructType\GetValue|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \RecruitCrm\LogicMelon\StructType\GetValue|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \RecruitCrm\LogicMelon\StructType\GetValue|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \RecruitCrm\LogicMelon\StructType\GetValue|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \RecruitCrm\LogicMelon\StructType\GetValue|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string GetValue
     */
    public function getAttributeName()
    {
        return 'GetValue';
    }
}
