<?php

namespace RecruitCrm\LogicMelon\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CQueryJobTitle StructType
 * @subpackage Structs
 */
class CQueryJobTitle extends AbstractStructBase
{
    /**
     * The Score
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Score;
    /**
     * The CultureID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CultureID;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Industry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Industry;
    /**
     * The JobTitle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $JobTitle;
    /**
     * Constructor method for CQueryJobTitle
     * @uses CQueryJobTitle::setScore()
     * @uses CQueryJobTitle::setCultureID()
     * @uses CQueryJobTitle::setDescription()
     * @uses CQueryJobTitle::setIndustry()
     * @uses CQueryJobTitle::setJobTitle()
     * @param int $score
     * @param string $cultureID
     * @param string $description
     * @param string $industry
     * @param string $jobTitle
     */
    public function __construct($score = null, $cultureID = null, $description = null, $industry = null, $jobTitle = null)
    {
        $this
            ->setScore($score)
            ->setCultureID($cultureID)
            ->setDescription($description)
            ->setIndustry($industry)
            ->setJobTitle($jobTitle);
    }
    /**
     * Get Score value
     * @return int
     */
    public function getScore()
    {
        return $this->Score;
    }
    /**
     * Set Score value
     * @param int $score
     * @return \RecruitCrm\LogicMelon\StructType\CQueryJobTitle
     */
    public function setScore($score = null)
    {
        // validation for constraint: int
        if (!is_null($score) && !(is_int($score) || ctype_digit($score))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($score, true), gettype($score)), __LINE__);
        }
        $this->Score = $score;
        return $this;
    }
    /**
     * Get CultureID value
     * @return string|null
     */
    public function getCultureID()
    {
        return $this->CultureID;
    }
    /**
     * Set CultureID value
     * @param string $cultureID
     * @return \RecruitCrm\LogicMelon\StructType\CQueryJobTitle
     */
    public function setCultureID($cultureID = null)
    {
        // validation for constraint: string
        if (!is_null($cultureID) && !is_string($cultureID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cultureID, true), gettype($cultureID)), __LINE__);
        }
        $this->CultureID = $cultureID;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \RecruitCrm\LogicMelon\StructType\CQueryJobTitle
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Industry value
     * @return string|null
     */
    public function getIndustry()
    {
        return $this->Industry;
    }
    /**
     * Set Industry value
     * @param string $industry
     * @return \RecruitCrm\LogicMelon\StructType\CQueryJobTitle
     */
    public function setIndustry($industry = null)
    {
        // validation for constraint: string
        if (!is_null($industry) && !is_string($industry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($industry, true), gettype($industry)), __LINE__);
        }
        $this->Industry = $industry;
        return $this;
    }
    /**
     * Get JobTitle value
     * @return string|null
     */
    public function getJobTitle()
    {
        return $this->JobTitle;
    }
    /**
     * Set JobTitle value
     * @param string $jobTitle
     * @return \RecruitCrm\LogicMelon\StructType\CQueryJobTitle
     */
    public function setJobTitle($jobTitle = null)
    {
        // validation for constraint: string
        if (!is_null($jobTitle) && !is_string($jobTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jobTitle, true), gettype($jobTitle)), __LINE__);
        }
        $this->JobTitle = $jobTitle;
        return $this;
    }
}
