<?php

namespace RecruitCrm\LogicMelon\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Close ServiceType
 * @subpackage Services
 */
class Close extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CloseAdvert
     * Meta information extracted from the WSDL
     * - documentation: <a name='CloseAdvert'></a><p>Provides a mechanism to search for an advert and request closure of the advert on job boards that support this feature.</p><p>Optionally specify a sUsername or sStartOrganisation to limit the search to a
     * specific user (sUsername or sUserIdentifier) or specific portion of the tree (sStartOrganisation).</p><ul><li><strong>Destinations</strong> Optionally a comma separated list of job board destinations as either numeric id's or string identifiers.
     * <strong>If not specified requests removals on all support destinations.</strong></li><li><strong>sArchive</strong> Optionally indicate if the advert should be archived on the local system as well (defaults to false)</li></ul> | <a
     * name='CloseAdvert'></a><p>Provides a mechanism to search for an advert and request closure of the advert on job boards that support this feature.</p><p>Optionally specify a sUsername or sStartOrganisation to limit the search to a specific user
     * (sUsername or sUserIdentifier) or specific portion of the tree (sStartOrganisation).</p><ul><li><strong>Destinations</strong> Optionally a comma separated list of job board destinations as either numeric id's or string identifiers. <strong>If not
     * specified requests removals on all support destinations.</strong></li><li><strong>sArchive</strong> Optionally indicate if the advert should be archived on the local system as well (defaults to false)</li></ul> | <a name='CloseAdvert'></a><p>Provides
     * a mechanism to search for an advert and request closure of the advert on job boards that support this feature.</p><p>Optionally specify a sUsername or sStartOrganisation to limit the search to a specific user (sUsername or sUserIdentifier) or
     * specific portion of the tree (sStartOrganisation).</p><ul><li><strong>Destinations</strong> Optionally a comma separated list of job board destinations as either numeric id's or string identifiers. <strong>If not specified requests removals on all
     * support destinations.</strong></li><li><strong>sArchive</strong> Optionally indicate if the advert should be archived on the local system as well (defaults to false)</li></ul>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RecruitCrm\LogicMelon\StructType\CloseAdvert $parameters
     * @return \RecruitCrm\LogicMelon\StructType\CloseAdvertResponse|bool
     */
    public function CloseAdvert(\RecruitCrm\LogicMelon\StructType\CloseAdvert $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CloseAdvert($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CloseAdvertWithFilters
     * Meta information extracted from the WSDL
     * - documentation: <a name='CloseAdvertWithFilters'></a><p>Provides a mechanism to search for an advert and request closure of the advert on job boards that support this feature. Allows extra search Filters to be included</p><p>Optionally specify a
     * sUsername or sStartOrganisation to limit the search to a specific user (sUsername or sUserIdentifier) or specific portion of the tree (sStartOrganisation).</p><ul><li><strong>Destinations</strong> Optionally a list of job board destinations as either
     * numeric id's or string identifiers. <strong>If not specified requests removals on all support destinations and closes the advert.</strong></li><li><strong>sArchive</strong> Optionally, when destinations are specified, indicate if the advert should be
     * archived on the local system as well (defaults to false)</li></ul>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RecruitCrm\LogicMelon\StructType\CloseAdvertWithFilters $parameters
     * @return \RecruitCrm\LogicMelon\StructType\CloseAdvertWithFiltersResponse|bool
     */
    public function CloseAdvertWithFilters(\RecruitCrm\LogicMelon\StructType\CloseAdvertWithFilters $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CloseAdvertWithFilters($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \RecruitCrm\LogicMelon\StructType\CloseAdvertResponse|\RecruitCrm\LogicMelon\StructType\CloseAdvertWithFiltersResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
