<?php

namespace RecruitCrm\LogicMelon\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for APIAdvertWithValuesPaged StructType
 * @subpackage Structs
 */
class APIAdvertWithValuesPaged extends AbstractStructBase
{
    /**
     * The PageCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PageCount;
    /**
     * The PageIndex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PageIndex;
    /**
     * The TotalItemCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TotalItemCount;
    /**
     * The AdvertWithValues
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \RecruitCrm\LogicMelon\ArrayType\ArrayOfAPIAdvertWithValues
     */
    public $AdvertWithValues;
    /**
     * Constructor method for APIAdvertWithValuesPaged
     * @uses APIAdvertWithValuesPaged::setPageCount()
     * @uses APIAdvertWithValuesPaged::setPageIndex()
     * @uses APIAdvertWithValuesPaged::setTotalItemCount()
     * @uses APIAdvertWithValuesPaged::setAdvertWithValues()
     * @param int $pageCount
     * @param int $pageIndex
     * @param int $totalItemCount
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfAPIAdvertWithValues $advertWithValues
     */
    public function __construct($pageCount = null, $pageIndex = null, $totalItemCount = null, \RecruitCrm\LogicMelon\ArrayType\ArrayOfAPIAdvertWithValues $advertWithValues = null)
    {
        $this
            ->setPageCount($pageCount)
            ->setPageIndex($pageIndex)
            ->setTotalItemCount($totalItemCount)
            ->setAdvertWithValues($advertWithValues);
    }
    /**
     * Get PageCount value
     * @return int
     */
    public function getPageCount()
    {
        return $this->PageCount;
    }
    /**
     * Set PageCount value
     * @param int $pageCount
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvertWithValuesPaged
     */
    public function setPageCount($pageCount = null)
    {
        // validation for constraint: int
        if (!is_null($pageCount) && !(is_int($pageCount) || ctype_digit($pageCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageCount, true), gettype($pageCount)), __LINE__);
        }
        $this->PageCount = $pageCount;
        return $this;
    }
    /**
     * Get PageIndex value
     * @return int
     */
    public function getPageIndex()
    {
        return $this->PageIndex;
    }
    /**
     * Set PageIndex value
     * @param int $pageIndex
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvertWithValuesPaged
     */
    public function setPageIndex($pageIndex = null)
    {
        // validation for constraint: int
        if (!is_null($pageIndex) && !(is_int($pageIndex) || ctype_digit($pageIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageIndex, true), gettype($pageIndex)), __LINE__);
        }
        $this->PageIndex = $pageIndex;
        return $this;
    }
    /**
     * Get TotalItemCount value
     * @return int
     */
    public function getTotalItemCount()
    {
        return $this->TotalItemCount;
    }
    /**
     * Set TotalItemCount value
     * @param int $totalItemCount
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvertWithValuesPaged
     */
    public function setTotalItemCount($totalItemCount = null)
    {
        // validation for constraint: int
        if (!is_null($totalItemCount) && !(is_int($totalItemCount) || ctype_digit($totalItemCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalItemCount, true), gettype($totalItemCount)), __LINE__);
        }
        $this->TotalItemCount = $totalItemCount;
        return $this;
    }
    /**
     * Get AdvertWithValues value
     * @return \RecruitCrm\LogicMelon\ArrayType\ArrayOfAPIAdvertWithValues|null
     */
    public function getAdvertWithValues()
    {
        return $this->AdvertWithValues;
    }
    /**
     * Set AdvertWithValues value
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfAPIAdvertWithValues $advertWithValues
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvertWithValuesPaged
     */
    public function setAdvertWithValues(\RecruitCrm\LogicMelon\ArrayType\ArrayOfAPIAdvertWithValues $advertWithValues = null)
    {
        $this->AdvertWithValues = $advertWithValues;
        return $this;
    }
}
