<?php

namespace RecruitCrm\LogicMelon\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidateAdvertResult StructType
 * @subpackage Structs
 */
class ValidateAdvertResult extends AbstractStructBase
{
    /**
     * The Valid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Valid;
    /**
     * The MarkedForDelivery
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $MarkedForDelivery;
    /**
     * The FieldIDsValid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \RecruitCrm\LogicMelon\ArrayType\ArrayOfInt
     */
    public $FieldIDsValid;
    /**
     * The FieldIDsWarning
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \RecruitCrm\LogicMelon\ArrayType\ArrayOfInt
     */
    public $FieldIDsWarning;
    /**
     * The FieldIDsInvalid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \RecruitCrm\LogicMelon\ArrayType\ArrayOfInt
     */
    public $FieldIDsInvalid;
    /**
     * The Destinations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \RecruitCrm\LogicMelon\ArrayType\ArrayOfInt
     */
    public $Destinations;
    /**
     * The ValidationResults
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \RecruitCrm\LogicMelon\ArrayType\ArrayOfValidateFieldResult
     */
    public $ValidationResults;
    /**
     * The APIAdvertWithPostings
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \RecruitCrm\LogicMelon\StructType\APIAdvertWithPostings
     */
    public $APIAdvertWithPostings;
    /**
     * Constructor method for ValidateAdvertResult
     * @uses ValidateAdvertResult::setValid()
     * @uses ValidateAdvertResult::setMarkedForDelivery()
     * @uses ValidateAdvertResult::setFieldIDsValid()
     * @uses ValidateAdvertResult::setFieldIDsWarning()
     * @uses ValidateAdvertResult::setFieldIDsInvalid()
     * @uses ValidateAdvertResult::setDestinations()
     * @uses ValidateAdvertResult::setValidationResults()
     * @uses ValidateAdvertResult::setAPIAdvertWithPostings()
     * @param string $valid
     * @param bool $markedForDelivery
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfInt $fieldIDsValid
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfInt $fieldIDsWarning
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfInt $fieldIDsInvalid
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfInt $destinations
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfValidateFieldResult $validationResults
     * @param \RecruitCrm\LogicMelon\StructType\APIAdvertWithPostings $aPIAdvertWithPostings
     */
    public function __construct($valid = null, $markedForDelivery = null, \RecruitCrm\LogicMelon\ArrayType\ArrayOfInt $fieldIDsValid = null, \RecruitCrm\LogicMelon\ArrayType\ArrayOfInt $fieldIDsWarning = null, \RecruitCrm\LogicMelon\ArrayType\ArrayOfInt $fieldIDsInvalid = null, \RecruitCrm\LogicMelon\ArrayType\ArrayOfInt $destinations = null, \RecruitCrm\LogicMelon\ArrayType\ArrayOfValidateFieldResult $validationResults = null, \RecruitCrm\LogicMelon\StructType\APIAdvertWithPostings $aPIAdvertWithPostings = null)
    {
        $this
            ->setValid($valid)
            ->setMarkedForDelivery($markedForDelivery)
            ->setFieldIDsValid($fieldIDsValid)
            ->setFieldIDsWarning($fieldIDsWarning)
            ->setFieldIDsInvalid($fieldIDsInvalid)
            ->setDestinations($destinations)
            ->setValidationResults($validationResults)
            ->setAPIAdvertWithPostings($aPIAdvertWithPostings);
    }
    /**
     * Get Valid value
     * @return string
     */
    public function getValid()
    {
        return $this->Valid;
    }
    /**
     * Set Valid value
     * @uses \RecruitCrm\LogicMelon\EnumType\ValidateAdvertValid::valueIsValid()
     * @uses \RecruitCrm\LogicMelon\EnumType\ValidateAdvertValid::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $valid
     * @return \RecruitCrm\LogicMelon\StructType\ValidateAdvertResult
     */
    public function setValid($valid = null)
    {
        // validation for constraint: enumeration
        if (!\RecruitCrm\LogicMelon\EnumType\ValidateAdvertValid::valueIsValid($valid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \RecruitCrm\LogicMelon\EnumType\ValidateAdvertValid', is_array($valid) ? implode(', ', $valid) : var_export($valid, true), implode(', ', \RecruitCrm\LogicMelon\EnumType\ValidateAdvertValid::getValidValues())), __LINE__);
        }
        $this->Valid = $valid;
        return $this;
    }
    /**
     * Get MarkedForDelivery value
     * @return bool
     */
    public function getMarkedForDelivery()
    {
        return $this->MarkedForDelivery;
    }
    /**
     * Set MarkedForDelivery value
     * @param bool $markedForDelivery
     * @return \RecruitCrm\LogicMelon\StructType\ValidateAdvertResult
     */
    public function setMarkedForDelivery($markedForDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($markedForDelivery) && !is_bool($markedForDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($markedForDelivery, true), gettype($markedForDelivery)), __LINE__);
        }
        $this->MarkedForDelivery = $markedForDelivery;
        return $this;
    }
    /**
     * Get FieldIDsValid value
     * @return \RecruitCrm\LogicMelon\ArrayType\ArrayOfInt|null
     */
    public function getFieldIDsValid()
    {
        return $this->FieldIDsValid;
    }
    /**
     * Set FieldIDsValid value
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfInt $fieldIDsValid
     * @return \RecruitCrm\LogicMelon\StructType\ValidateAdvertResult
     */
    public function setFieldIDsValid(\RecruitCrm\LogicMelon\ArrayType\ArrayOfInt $fieldIDsValid = null)
    {
        $this->FieldIDsValid = $fieldIDsValid;
        return $this;
    }
    /**
     * Get FieldIDsWarning value
     * @return \RecruitCrm\LogicMelon\ArrayType\ArrayOfInt|null
     */
    public function getFieldIDsWarning()
    {
        return $this->FieldIDsWarning;
    }
    /**
     * Set FieldIDsWarning value
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfInt $fieldIDsWarning
     * @return \RecruitCrm\LogicMelon\StructType\ValidateAdvertResult
     */
    public function setFieldIDsWarning(\RecruitCrm\LogicMelon\ArrayType\ArrayOfInt $fieldIDsWarning = null)
    {
        $this->FieldIDsWarning = $fieldIDsWarning;
        return $this;
    }
    /**
     * Get FieldIDsInvalid value
     * @return \RecruitCrm\LogicMelon\ArrayType\ArrayOfInt|null
     */
    public function getFieldIDsInvalid()
    {
        return $this->FieldIDsInvalid;
    }
    /**
     * Set FieldIDsInvalid value
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfInt $fieldIDsInvalid
     * @return \RecruitCrm\LogicMelon\StructType\ValidateAdvertResult
     */
    public function setFieldIDsInvalid(\RecruitCrm\LogicMelon\ArrayType\ArrayOfInt $fieldIDsInvalid = null)
    {
        $this->FieldIDsInvalid = $fieldIDsInvalid;
        return $this;
    }
    /**
     * Get Destinations value
     * @return \RecruitCrm\LogicMelon\ArrayType\ArrayOfInt|null
     */
    public function getDestinations()
    {
        return $this->Destinations;
    }
    /**
     * Set Destinations value
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfInt $destinations
     * @return \RecruitCrm\LogicMelon\StructType\ValidateAdvertResult
     */
    public function setDestinations(\RecruitCrm\LogicMelon\ArrayType\ArrayOfInt $destinations = null)
    {
        $this->Destinations = $destinations;
        return $this;
    }
    /**
     * Get ValidationResults value
     * @return \RecruitCrm\LogicMelon\ArrayType\ArrayOfValidateFieldResult|null
     */
    public function getValidationResults()
    {
        return $this->ValidationResults;
    }
    /**
     * Set ValidationResults value
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfValidateFieldResult $validationResults
     * @return \RecruitCrm\LogicMelon\StructType\ValidateAdvertResult
     */
    public function setValidationResults(\RecruitCrm\LogicMelon\ArrayType\ArrayOfValidateFieldResult $validationResults = null)
    {
        $this->ValidationResults = $validationResults;
        return $this;
    }
    /**
     * Get APIAdvertWithPostings value
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvertWithPostings|null
     */
    public function getAPIAdvertWithPostings()
    {
        return $this->APIAdvertWithPostings;
    }
    /**
     * Set APIAdvertWithPostings value
     * @param \RecruitCrm\LogicMelon\StructType\APIAdvertWithPostings $aPIAdvertWithPostings
     * @return \RecruitCrm\LogicMelon\StructType\ValidateAdvertResult
     */
    public function setAPIAdvertWithPostings(\RecruitCrm\LogicMelon\StructType\APIAdvertWithPostings $aPIAdvertWithPostings = null)
    {
        $this->APIAdvertWithPostings = $aPIAdvertWithPostings;
        return $this;
    }
}
