<?php

namespace RecruitCrm\LogicMelon\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NameValueFilter StructType
 * @subpackage Structs
 */
class NameValueFilter extends AbstractStructBase
{
    /**
     * The ValueDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ValueDateTime;
    /**
     * The Comparitor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Comparitor;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Value;
    /**
     * The Values
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \RecruitCrm\LogicMelon\ArrayType\ArrayOfString
     */
    public $Values;
    /**
     * Constructor method for NameValueFilter
     * @uses NameValueFilter::setValueDateTime()
     * @uses NameValueFilter::setComparitor()
     * @uses NameValueFilter::setName()
     * @uses NameValueFilter::setValue()
     * @uses NameValueFilter::setValues()
     * @param string $valueDateTime
     * @param string $comparitor
     * @param string $name
     * @param string $value
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfString $values
     */
    public function __construct($valueDateTime = null, $comparitor = null, $name = null, $value = null, \RecruitCrm\LogicMelon\ArrayType\ArrayOfString $values = null)
    {
        $this
            ->setValueDateTime($valueDateTime)
            ->setComparitor($comparitor)
            ->setName($name)
            ->setValue($value)
            ->setValues($values);
    }
    /**
     * Get ValueDateTime value
     * @return string
     */
    public function getValueDateTime()
    {
        return $this->ValueDateTime;
    }
    /**
     * Set ValueDateTime value
     * @param string $valueDateTime
     * @return \RecruitCrm\LogicMelon\StructType\NameValueFilter
     */
    public function setValueDateTime($valueDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($valueDateTime) && !is_string($valueDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valueDateTime, true), gettype($valueDateTime)), __LINE__);
        }
        $this->ValueDateTime = $valueDateTime;
        return $this;
    }
    /**
     * Get Comparitor value
     * @return string
     */
    public function getComparitor()
    {
        return $this->Comparitor;
    }
    /**
     * Set Comparitor value
     * @uses \RecruitCrm\LogicMelon\EnumType\SearchFieldAndValueComparitor::valueIsValid()
     * @uses \RecruitCrm\LogicMelon\EnumType\SearchFieldAndValueComparitor::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $comparitor
     * @return \RecruitCrm\LogicMelon\StructType\NameValueFilter
     */
    public function setComparitor($comparitor = null)
    {
        // validation for constraint: enumeration
        if (!\RecruitCrm\LogicMelon\EnumType\SearchFieldAndValueComparitor::valueIsValid($comparitor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \RecruitCrm\LogicMelon\EnumType\SearchFieldAndValueComparitor', is_array($comparitor) ? implode(', ', $comparitor) : var_export($comparitor, true), implode(', ', \RecruitCrm\LogicMelon\EnumType\SearchFieldAndValueComparitor::getValidValues())), __LINE__);
        }
        $this->Comparitor = $comparitor;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \RecruitCrm\LogicMelon\StructType\NameValueFilter
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \RecruitCrm\LogicMelon\StructType\NameValueFilter
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get Values value
     * @return \RecruitCrm\LogicMelon\ArrayType\ArrayOfString|null
     */
    public function getValues()
    {
        return $this->Values;
    }
    /**
     * Set Values value
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfString $values
     * @return \RecruitCrm\LogicMelon\StructType\NameValueFilter
     */
    public function setValues(\RecruitCrm\LogicMelon\ArrayType\ArrayOfString $values = null)
    {
        $this->Values = $values;
        return $this;
    }
}
