<?php

namespace RecruitCrm\LogicMelon\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CPostFeed StructType
 * @subpackage Structs
 */
class CPostFeed extends AbstractStructBase
{
    /**
     * The EffectiveQuota
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $EffectiveQuota;
    /**
     * The FeedID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FeedID;
    /**
     * The Postings
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Postings;
    /**
     * The Slots
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Slots;
    /**
     * The Spend
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Spend;
    /**
     * The UserID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $UserID;
    /**
     * The DefaultSelected
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DefaultSelected;
    /**
     * The ForceSelected
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ForceSelected;
    /**
     * The Restricted
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Restricted;
    /**
     * The FeedCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $FeedCost;
    /**
     * The FeedCostTypeID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $FeedCostTypeID;
    /**
     * The JobDescriptionMinimumLength
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $JobDescriptionMinimumLength;
    /**
     * The JobDescriptionMaximumLength
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $JobDescriptionMaximumLength;
    /**
     * The PostingsUsed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $PostingsUsed;
    /**
     * The SpendUsed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $SpendUsed;
    /**
     * The PostingsForward
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $PostingsForward;
    /**
     * The CultureID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CultureID;
    /**
     * The CurrencyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyID;
    /**
     * The FeedIdentifier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FeedIdentifier;
    /**
     * The FeedName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FeedName;
    /**
     * The LogoURL
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LogoURL;
    /**
     * The ShortDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShortDescription;
    /**
     * The FeedCostType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FeedCostType;
    /**
     * The HTMLSupport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HTMLSupport;
    /**
     * The SpendUsedCurrencyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SpendUsedCurrencyID;
    /**
     * Constructor method for CPostFeed
     * @uses CPostFeed::setEffectiveQuota()
     * @uses CPostFeed::setFeedID()
     * @uses CPostFeed::setPostings()
     * @uses CPostFeed::setSlots()
     * @uses CPostFeed::setSpend()
     * @uses CPostFeed::setUserID()
     * @uses CPostFeed::setDefaultSelected()
     * @uses CPostFeed::setForceSelected()
     * @uses CPostFeed::setRestricted()
     * @uses CPostFeed::setFeedCost()
     * @uses CPostFeed::setFeedCostTypeID()
     * @uses CPostFeed::setJobDescriptionMinimumLength()
     * @uses CPostFeed::setJobDescriptionMaximumLength()
     * @uses CPostFeed::setPostingsUsed()
     * @uses CPostFeed::setSpendUsed()
     * @uses CPostFeed::setPostingsForward()
     * @uses CPostFeed::setCultureID()
     * @uses CPostFeed::setCurrencyID()
     * @uses CPostFeed::setFeedIdentifier()
     * @uses CPostFeed::setFeedName()
     * @uses CPostFeed::setLogoURL()
     * @uses CPostFeed::setShortDescription()
     * @uses CPostFeed::setFeedCostType()
     * @uses CPostFeed::setHTMLSupport()
     * @uses CPostFeed::setSpendUsedCurrencyID()
     * @param float $effectiveQuota
     * @param int $feedID
     * @param float $postings
     * @param float $slots
     * @param float $spend
     * @param int $userID
     * @param string $defaultSelected
     * @param string $forceSelected
     * @param string $restricted
     * @param float $feedCost
     * @param string $feedCostTypeID
     * @param int $jobDescriptionMinimumLength
     * @param int $jobDescriptionMaximumLength
     * @param float $postingsUsed
     * @param float $spendUsed
     * @param float $postingsForward
     * @param string $cultureID
     * @param string $currencyID
     * @param string $feedIdentifier
     * @param string $feedName
     * @param string $logoURL
     * @param string $shortDescription
     * @param string $feedCostType
     * @param string $hTMLSupport
     * @param string $spendUsedCurrencyID
     */
    public function __construct($effectiveQuota = null, $feedID = null, $postings = null, $slots = null, $spend = null, $userID = null, $defaultSelected = null, $forceSelected = null, $restricted = null, $feedCost = null, $feedCostTypeID = null, $jobDescriptionMinimumLength = null, $jobDescriptionMaximumLength = null, $postingsUsed = null, $spendUsed = null, $postingsForward = null, $cultureID = null, $currencyID = null, $feedIdentifier = null, $feedName = null, $logoURL = null, $shortDescription = null, $feedCostType = null, $hTMLSupport = null, $spendUsedCurrencyID = null)
    {
        $this
            ->setEffectiveQuota($effectiveQuota)
            ->setFeedID($feedID)
            ->setPostings($postings)
            ->setSlots($slots)
            ->setSpend($spend)
            ->setUserID($userID)
            ->setDefaultSelected($defaultSelected)
            ->setForceSelected($forceSelected)
            ->setRestricted($restricted)
            ->setFeedCost($feedCost)
            ->setFeedCostTypeID($feedCostTypeID)
            ->setJobDescriptionMinimumLength($jobDescriptionMinimumLength)
            ->setJobDescriptionMaximumLength($jobDescriptionMaximumLength)
            ->setPostingsUsed($postingsUsed)
            ->setSpendUsed($spendUsed)
            ->setPostingsForward($postingsForward)
            ->setCultureID($cultureID)
            ->setCurrencyID($currencyID)
            ->setFeedIdentifier($feedIdentifier)
            ->setFeedName($feedName)
            ->setLogoURL($logoURL)
            ->setShortDescription($shortDescription)
            ->setFeedCostType($feedCostType)
            ->setHTMLSupport($hTMLSupport)
            ->setSpendUsedCurrencyID($spendUsedCurrencyID);
    }
    /**
     * Get EffectiveQuota value
     * @return float
     */
    public function getEffectiveQuota()
    {
        return $this->EffectiveQuota;
    }
    /**
     * Set EffectiveQuota value
     * @param float $effectiveQuota
     * @return \RecruitCrm\LogicMelon\StructType\CPostFeed
     */
    public function setEffectiveQuota($effectiveQuota = null)
    {
        // validation for constraint: float
        if (!is_null($effectiveQuota) && !(is_float($effectiveQuota) || is_numeric($effectiveQuota))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($effectiveQuota, true), gettype($effectiveQuota)), __LINE__);
        }
        $this->EffectiveQuota = $effectiveQuota;
        return $this;
    }
    /**
     * Get FeedID value
     * @return int
     */
    public function getFeedID()
    {
        return $this->FeedID;
    }
    /**
     * Set FeedID value
     * @param int $feedID
     * @return \RecruitCrm\LogicMelon\StructType\CPostFeed
     */
    public function setFeedID($feedID = null)
    {
        // validation for constraint: int
        if (!is_null($feedID) && !(is_int($feedID) || ctype_digit($feedID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($feedID, true), gettype($feedID)), __LINE__);
        }
        $this->FeedID = $feedID;
        return $this;
    }
    /**
     * Get Postings value
     * @return float
     */
    public function getPostings()
    {
        return $this->Postings;
    }
    /**
     * Set Postings value
     * @param float $postings
     * @return \RecruitCrm\LogicMelon\StructType\CPostFeed
     */
    public function setPostings($postings = null)
    {
        // validation for constraint: float
        if (!is_null($postings) && !(is_float($postings) || is_numeric($postings))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($postings, true), gettype($postings)), __LINE__);
        }
        $this->Postings = $postings;
        return $this;
    }
    /**
     * Get Slots value
     * @return float
     */
    public function getSlots()
    {
        return $this->Slots;
    }
    /**
     * Set Slots value
     * @param float $slots
     * @return \RecruitCrm\LogicMelon\StructType\CPostFeed
     */
    public function setSlots($slots = null)
    {
        // validation for constraint: float
        if (!is_null($slots) && !(is_float($slots) || is_numeric($slots))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($slots, true), gettype($slots)), __LINE__);
        }
        $this->Slots = $slots;
        return $this;
    }
    /**
     * Get Spend value
     * @return float
     */
    public function getSpend()
    {
        return $this->Spend;
    }
    /**
     * Set Spend value
     * @param float $spend
     * @return \RecruitCrm\LogicMelon\StructType\CPostFeed
     */
    public function setSpend($spend = null)
    {
        // validation for constraint: float
        if (!is_null($spend) && !(is_float($spend) || is_numeric($spend))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($spend, true), gettype($spend)), __LINE__);
        }
        $this->Spend = $spend;
        return $this;
    }
    /**
     * Get UserID value
     * @return int
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param int $userID
     * @return \RecruitCrm\LogicMelon\StructType\CPostFeed
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: int
        if (!is_null($userID) && !(is_int($userID) || ctype_digit($userID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($userID, true), gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get DefaultSelected value
     * @return string
     */
    public function getDefaultSelected()
    {
        return $this->DefaultSelected;
    }
    /**
     * Set DefaultSelected value
     * @param string $defaultSelected
     * @return \RecruitCrm\LogicMelon\StructType\CPostFeed
     */
    public function setDefaultSelected($defaultSelected = null)
    {
        // validation for constraint: string
        if (!is_null($defaultSelected) && !is_string($defaultSelected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultSelected, true), gettype($defaultSelected)), __LINE__);
        }
        $this->DefaultSelected = $defaultSelected;
        return $this;
    }
    /**
     * Get ForceSelected value
     * @return string
     */
    public function getForceSelected()
    {
        return $this->ForceSelected;
    }
    /**
     * Set ForceSelected value
     * @param string $forceSelected
     * @return \RecruitCrm\LogicMelon\StructType\CPostFeed
     */
    public function setForceSelected($forceSelected = null)
    {
        // validation for constraint: string
        if (!is_null($forceSelected) && !is_string($forceSelected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forceSelected, true), gettype($forceSelected)), __LINE__);
        }
        $this->ForceSelected = $forceSelected;
        return $this;
    }
    /**
     * Get Restricted value
     * @return string
     */
    public function getRestricted()
    {
        return $this->Restricted;
    }
    /**
     * Set Restricted value
     * @param string $restricted
     * @return \RecruitCrm\LogicMelon\StructType\CPostFeed
     */
    public function setRestricted($restricted = null)
    {
        // validation for constraint: string
        if (!is_null($restricted) && !is_string($restricted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($restricted, true), gettype($restricted)), __LINE__);
        }
        $this->Restricted = $restricted;
        return $this;
    }
    /**
     * Get FeedCost value
     * @return float
     */
    public function getFeedCost()
    {
        return $this->FeedCost;
    }
    /**
     * Set FeedCost value
     * @param float $feedCost
     * @return \RecruitCrm\LogicMelon\StructType\CPostFeed
     */
    public function setFeedCost($feedCost = null)
    {
        // validation for constraint: float
        if (!is_null($feedCost) && !(is_float($feedCost) || is_numeric($feedCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($feedCost, true), gettype($feedCost)), __LINE__);
        }
        $this->FeedCost = $feedCost;
        return $this;
    }
    /**
     * Get FeedCostTypeID value
     * @return string
     */
    public function getFeedCostTypeID()
    {
        return $this->FeedCostTypeID;
    }
    /**
     * Set FeedCostTypeID value
     * @param string $feedCostTypeID
     * @return \RecruitCrm\LogicMelon\StructType\CPostFeed
     */
    public function setFeedCostTypeID($feedCostTypeID = null)
    {
        // validation for constraint: string
        if (!is_null($feedCostTypeID) && !is_string($feedCostTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feedCostTypeID, true), gettype($feedCostTypeID)), __LINE__);
        }
        $this->FeedCostTypeID = $feedCostTypeID;
        return $this;
    }
    /**
     * Get JobDescriptionMinimumLength value
     * @return int
     */
    public function getJobDescriptionMinimumLength()
    {
        return $this->JobDescriptionMinimumLength;
    }
    /**
     * Set JobDescriptionMinimumLength value
     * @param int $jobDescriptionMinimumLength
     * @return \RecruitCrm\LogicMelon\StructType\CPostFeed
     */
    public function setJobDescriptionMinimumLength($jobDescriptionMinimumLength = null)
    {
        // validation for constraint: int
        if (!is_null($jobDescriptionMinimumLength) && !(is_int($jobDescriptionMinimumLength) || ctype_digit($jobDescriptionMinimumLength))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($jobDescriptionMinimumLength, true), gettype($jobDescriptionMinimumLength)), __LINE__);
        }
        $this->JobDescriptionMinimumLength = $jobDescriptionMinimumLength;
        return $this;
    }
    /**
     * Get JobDescriptionMaximumLength value
     * @return int
     */
    public function getJobDescriptionMaximumLength()
    {
        return $this->JobDescriptionMaximumLength;
    }
    /**
     * Set JobDescriptionMaximumLength value
     * @param int $jobDescriptionMaximumLength
     * @return \RecruitCrm\LogicMelon\StructType\CPostFeed
     */
    public function setJobDescriptionMaximumLength($jobDescriptionMaximumLength = null)
    {
        // validation for constraint: int
        if (!is_null($jobDescriptionMaximumLength) && !(is_int($jobDescriptionMaximumLength) || ctype_digit($jobDescriptionMaximumLength))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($jobDescriptionMaximumLength, true), gettype($jobDescriptionMaximumLength)), __LINE__);
        }
        $this->JobDescriptionMaximumLength = $jobDescriptionMaximumLength;
        return $this;
    }
    /**
     * Get PostingsUsed value
     * @return float
     */
    public function getPostingsUsed()
    {
        return $this->PostingsUsed;
    }
    /**
     * Set PostingsUsed value
     * @param float $postingsUsed
     * @return \RecruitCrm\LogicMelon\StructType\CPostFeed
     */
    public function setPostingsUsed($postingsUsed = null)
    {
        // validation for constraint: float
        if (!is_null($postingsUsed) && !(is_float($postingsUsed) || is_numeric($postingsUsed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($postingsUsed, true), gettype($postingsUsed)), __LINE__);
        }
        $this->PostingsUsed = $postingsUsed;
        return $this;
    }
    /**
     * Get SpendUsed value
     * @return float
     */
    public function getSpendUsed()
    {
        return $this->SpendUsed;
    }
    /**
     * Set SpendUsed value
     * @param float $spendUsed
     * @return \RecruitCrm\LogicMelon\StructType\CPostFeed
     */
    public function setSpendUsed($spendUsed = null)
    {
        // validation for constraint: float
        if (!is_null($spendUsed) && !(is_float($spendUsed) || is_numeric($spendUsed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($spendUsed, true), gettype($spendUsed)), __LINE__);
        }
        $this->SpendUsed = $spendUsed;
        return $this;
    }
    /**
     * Get PostingsForward value
     * @return float
     */
    public function getPostingsForward()
    {
        return $this->PostingsForward;
    }
    /**
     * Set PostingsForward value
     * @param float $postingsForward
     * @return \RecruitCrm\LogicMelon\StructType\CPostFeed
     */
    public function setPostingsForward($postingsForward = null)
    {
        // validation for constraint: float
        if (!is_null($postingsForward) && !(is_float($postingsForward) || is_numeric($postingsForward))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($postingsForward, true), gettype($postingsForward)), __LINE__);
        }
        $this->PostingsForward = $postingsForward;
        return $this;
    }
    /**
     * Get CultureID value
     * @return string|null
     */
    public function getCultureID()
    {
        return $this->CultureID;
    }
    /**
     * Set CultureID value
     * @param string $cultureID
     * @return \RecruitCrm\LogicMelon\StructType\CPostFeed
     */
    public function setCultureID($cultureID = null)
    {
        // validation for constraint: string
        if (!is_null($cultureID) && !is_string($cultureID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cultureID, true), gettype($cultureID)), __LINE__);
        }
        $this->CultureID = $cultureID;
        return $this;
    }
    /**
     * Get CurrencyID value
     * @return string|null
     */
    public function getCurrencyID()
    {
        return $this->CurrencyID;
    }
    /**
     * Set CurrencyID value
     * @param string $currencyID
     * @return \RecruitCrm\LogicMelon\StructType\CPostFeed
     */
    public function setCurrencyID($currencyID = null)
    {
        // validation for constraint: string
        if (!is_null($currencyID) && !is_string($currencyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyID, true), gettype($currencyID)), __LINE__);
        }
        $this->CurrencyID = $currencyID;
        return $this;
    }
    /**
     * Get FeedIdentifier value
     * @return string|null
     */
    public function getFeedIdentifier()
    {
        return $this->FeedIdentifier;
    }
    /**
     * Set FeedIdentifier value
     * @param string $feedIdentifier
     * @return \RecruitCrm\LogicMelon\StructType\CPostFeed
     */
    public function setFeedIdentifier($feedIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($feedIdentifier) && !is_string($feedIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feedIdentifier, true), gettype($feedIdentifier)), __LINE__);
        }
        $this->FeedIdentifier = $feedIdentifier;
        return $this;
    }
    /**
     * Get FeedName value
     * @return string|null
     */
    public function getFeedName()
    {
        return $this->FeedName;
    }
    /**
     * Set FeedName value
     * @param string $feedName
     * @return \RecruitCrm\LogicMelon\StructType\CPostFeed
     */
    public function setFeedName($feedName = null)
    {
        // validation for constraint: string
        if (!is_null($feedName) && !is_string($feedName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feedName, true), gettype($feedName)), __LINE__);
        }
        $this->FeedName = $feedName;
        return $this;
    }
    /**
     * Get LogoURL value
     * @return string|null
     */
    public function getLogoURL()
    {
        return $this->LogoURL;
    }
    /**
     * Set LogoURL value
     * @param string $logoURL
     * @return \RecruitCrm\LogicMelon\StructType\CPostFeed
     */
    public function setLogoURL($logoURL = null)
    {
        // validation for constraint: string
        if (!is_null($logoURL) && !is_string($logoURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($logoURL, true), gettype($logoURL)), __LINE__);
        }
        $this->LogoURL = $logoURL;
        return $this;
    }
    /**
     * Get ShortDescription value
     * @return string|null
     */
    public function getShortDescription()
    {
        return $this->ShortDescription;
    }
    /**
     * Set ShortDescription value
     * @param string $shortDescription
     * @return \RecruitCrm\LogicMelon\StructType\CPostFeed
     */
    public function setShortDescription($shortDescription = null)
    {
        // validation for constraint: string
        if (!is_null($shortDescription) && !is_string($shortDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shortDescription, true), gettype($shortDescription)), __LINE__);
        }
        $this->ShortDescription = $shortDescription;
        return $this;
    }
    /**
     * Get FeedCostType value
     * @return string|null
     */
    public function getFeedCostType()
    {
        return $this->FeedCostType;
    }
    /**
     * Set FeedCostType value
     * @param string $feedCostType
     * @return \RecruitCrm\LogicMelon\StructType\CPostFeed
     */
    public function setFeedCostType($feedCostType = null)
    {
        // validation for constraint: string
        if (!is_null($feedCostType) && !is_string($feedCostType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feedCostType, true), gettype($feedCostType)), __LINE__);
        }
        $this->FeedCostType = $feedCostType;
        return $this;
    }
    /**
     * Get HTMLSupport value
     * @return string|null
     */
    public function getHTMLSupport()
    {
        return $this->HTMLSupport;
    }
    /**
     * Set HTMLSupport value
     * @param string $hTMLSupport
     * @return \RecruitCrm\LogicMelon\StructType\CPostFeed
     */
    public function setHTMLSupport($hTMLSupport = null)
    {
        // validation for constraint: string
        if (!is_null($hTMLSupport) && !is_string($hTMLSupport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hTMLSupport, true), gettype($hTMLSupport)), __LINE__);
        }
        $this->HTMLSupport = $hTMLSupport;
        return $this;
    }
    /**
     * Get SpendUsedCurrencyID value
     * @return string|null
     */
    public function getSpendUsedCurrencyID()
    {
        return $this->SpendUsedCurrencyID;
    }
    /**
     * Set SpendUsedCurrencyID value
     * @param string $spendUsedCurrencyID
     * @return \RecruitCrm\LogicMelon\StructType\CPostFeed
     */
    public function setSpendUsedCurrencyID($spendUsedCurrencyID = null)
    {
        // validation for constraint: string
        if (!is_null($spendUsedCurrencyID) && !is_string($spendUsedCurrencyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spendUsedCurrencyID, true), gettype($spendUsedCurrencyID)), __LINE__);
        }
        $this->SpendUsedCurrencyID = $spendUsedCurrencyID;
        return $this;
    }
}
