<?php

namespace RecruitCrm\LogicMelon\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for APIApplicationPaged StructType
 * @subpackage Structs
 */
class APIApplicationPaged extends AbstractStructBase
{
    /**
     * The PageCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PageCount;
    /**
     * The PageIndex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PageIndex;
    /**
     * The TotalItemCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TotalItemCount;
    /**
     * The Applications
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \RecruitCrm\LogicMelon\ArrayType\ArrayOfAPIApplication
     */
    public $Applications;
    /**
     * Constructor method for APIApplicationPaged
     * @uses APIApplicationPaged::setPageCount()
     * @uses APIApplicationPaged::setPageIndex()
     * @uses APIApplicationPaged::setTotalItemCount()
     * @uses APIApplicationPaged::setApplications()
     * @param int $pageCount
     * @param int $pageIndex
     * @param int $totalItemCount
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfAPIApplication $applications
     */
    public function __construct($pageCount = null, $pageIndex = null, $totalItemCount = null, \RecruitCrm\LogicMelon\ArrayType\ArrayOfAPIApplication $applications = null)
    {
        $this
            ->setPageCount($pageCount)
            ->setPageIndex($pageIndex)
            ->setTotalItemCount($totalItemCount)
            ->setApplications($applications);
    }
    /**
     * Get PageCount value
     * @return int
     */
    public function getPageCount()
    {
        return $this->PageCount;
    }
    /**
     * Set PageCount value
     * @param int $pageCount
     * @return \RecruitCrm\LogicMelon\StructType\APIApplicationPaged
     */
    public function setPageCount($pageCount = null)
    {
        // validation for constraint: int
        if (!is_null($pageCount) && !(is_int($pageCount) || ctype_digit($pageCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageCount, true), gettype($pageCount)), __LINE__);
        }
        $this->PageCount = $pageCount;
        return $this;
    }
    /**
     * Get PageIndex value
     * @return int
     */
    public function getPageIndex()
    {
        return $this->PageIndex;
    }
    /**
     * Set PageIndex value
     * @param int $pageIndex
     * @return \RecruitCrm\LogicMelon\StructType\APIApplicationPaged
     */
    public function setPageIndex($pageIndex = null)
    {
        // validation for constraint: int
        if (!is_null($pageIndex) && !(is_int($pageIndex) || ctype_digit($pageIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageIndex, true), gettype($pageIndex)), __LINE__);
        }
        $this->PageIndex = $pageIndex;
        return $this;
    }
    /**
     * Get TotalItemCount value
     * @return int
     */
    public function getTotalItemCount()
    {
        return $this->TotalItemCount;
    }
    /**
     * Set TotalItemCount value
     * @param int $totalItemCount
     * @return \RecruitCrm\LogicMelon\StructType\APIApplicationPaged
     */
    public function setTotalItemCount($totalItemCount = null)
    {
        // validation for constraint: int
        if (!is_null($totalItemCount) && !(is_int($totalItemCount) || ctype_digit($totalItemCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalItemCount, true), gettype($totalItemCount)), __LINE__);
        }
        $this->TotalItemCount = $totalItemCount;
        return $this;
    }
    /**
     * Get Applications value
     * @return \RecruitCrm\LogicMelon\ArrayType\ArrayOfAPIApplication|null
     */
    public function getApplications()
    {
        return $this->Applications;
    }
    /**
     * Set Applications value
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfAPIApplication $applications
     * @return \RecruitCrm\LogicMelon\StructType\APIApplicationPaged
     */
    public function setApplications(\RecruitCrm\LogicMelon\ArrayType\ArrayOfAPIApplication $applications = null)
    {
        $this->Applications = $applications;
        return $this;
    }
}
