<?php

namespace RecruitCrm\LogicMelon\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfNameValueFilter ArrayType
 * @subpackage Arrays
 */
class ArrayOfNameValueFilter extends AbstractStructArrayBase
{
    /**
     * The NameValueFilter
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \RecruitCrm\LogicMelon\StructType\NameValueFilter[]
     */
    public $NameValueFilter;
    /**
     * Constructor method for ArrayOfNameValueFilter
     * @uses ArrayOfNameValueFilter::setNameValueFilter()
     * @param \RecruitCrm\LogicMelon\StructType\NameValueFilter[] $nameValueFilter
     */
    public function __construct(array $nameValueFilter = array())
    {
        $this
            ->setNameValueFilter($nameValueFilter);
    }
    /**
     * Get NameValueFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RecruitCrm\LogicMelon\StructType\NameValueFilter[]|null
     */
    public function getNameValueFilter()
    {
        return isset($this->NameValueFilter) ? $this->NameValueFilter : null;
    }
    /**
     * This method is responsible for validating the values passed to the setNameValueFilter method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNameValueFilter method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNameValueFilterForArrayConstraintsFromSetNameValueFilter(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfNameValueFilterNameValueFilterItem) {
            // validation for constraint: itemType
            if (!$arrayOfNameValueFilterNameValueFilterItem instanceof \RecruitCrm\LogicMelon\StructType\NameValueFilter) {
                $invalidValues[] = is_object($arrayOfNameValueFilterNameValueFilterItem) ? get_class($arrayOfNameValueFilterNameValueFilterItem) : sprintf('%s(%s)', gettype($arrayOfNameValueFilterNameValueFilterItem), var_export($arrayOfNameValueFilterNameValueFilterItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The NameValueFilter property can only contain items of type \RecruitCrm\LogicMelon\StructType\NameValueFilter, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set NameValueFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \RecruitCrm\LogicMelon\StructType\NameValueFilter[] $nameValueFilter
     * @return \RecruitCrm\LogicMelon\ArrayType\ArrayOfNameValueFilter
     */
    public function setNameValueFilter(array $nameValueFilter = array())
    {
        // validation for constraint: array
        if ('' !== ($nameValueFilterArrayErrorMessage = self::validateNameValueFilterForArrayConstraintsFromSetNameValueFilter($nameValueFilter))) {
            throw new \InvalidArgumentException($nameValueFilterArrayErrorMessage, __LINE__);
        }
        if (is_null($nameValueFilter) || (is_array($nameValueFilter) && empty($nameValueFilter))) {
            unset($this->NameValueFilter);
        } else {
            $this->NameValueFilter = $nameValueFilter;
        }
        return $this;
    }
    /**
     * Add item to NameValueFilter value
     * @throws \InvalidArgumentException
     * @param \RecruitCrm\LogicMelon\StructType\NameValueFilter $item
     * @return \RecruitCrm\LogicMelon\ArrayType\ArrayOfNameValueFilter
     */
    public function addToNameValueFilter(\RecruitCrm\LogicMelon\StructType\NameValueFilter $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \RecruitCrm\LogicMelon\StructType\NameValueFilter) {
            throw new \InvalidArgumentException(sprintf('The NameValueFilter property can only contain items of type \RecruitCrm\LogicMelon\StructType\NameValueFilter, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->NameValueFilter[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \RecruitCrm\LogicMelon\StructType\NameValueFilter|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \RecruitCrm\LogicMelon\StructType\NameValueFilter|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \RecruitCrm\LogicMelon\StructType\NameValueFilter|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \RecruitCrm\LogicMelon\StructType\NameValueFilter|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \RecruitCrm\LogicMelon\StructType\NameValueFilter|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string NameValueFilter
     */
    public function getAttributeName()
    {
        return 'NameValueFilter';
    }
}
