<?php

namespace RecruitCrm\LogicMelon\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAPIPosting ArrayType
 * @subpackage Arrays
 */
class ArrayOfAPIPosting extends AbstractStructArrayBase
{
    /**
     * The APIPosting
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \RecruitCrm\LogicMelon\StructType\APIPosting[]
     */
    public $APIPosting;
    /**
     * Constructor method for ArrayOfAPIPosting
     * @uses ArrayOfAPIPosting::setAPIPosting()
     * @param \RecruitCrm\LogicMelon\StructType\APIPosting[] $aPIPosting
     */
    public function __construct(array $aPIPosting = array())
    {
        $this
            ->setAPIPosting($aPIPosting);
    }
    /**
     * Get APIPosting value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RecruitCrm\LogicMelon\StructType\APIPosting[]|null
     */
    public function getAPIPosting()
    {
        return isset($this->APIPosting) ? $this->APIPosting : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAPIPosting method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAPIPosting method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAPIPostingForArrayConstraintsFromSetAPIPosting(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfAPIPostingAPIPostingItem) {
            // validation for constraint: itemType
            if (!$arrayOfAPIPostingAPIPostingItem instanceof \RecruitCrm\LogicMelon\StructType\APIPosting) {
                $invalidValues[] = is_object($arrayOfAPIPostingAPIPostingItem) ? get_class($arrayOfAPIPostingAPIPostingItem) : sprintf('%s(%s)', gettype($arrayOfAPIPostingAPIPostingItem), var_export($arrayOfAPIPostingAPIPostingItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The APIPosting property can only contain items of type \RecruitCrm\LogicMelon\StructType\APIPosting, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set APIPosting value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \RecruitCrm\LogicMelon\StructType\APIPosting[] $aPIPosting
     * @return \RecruitCrm\LogicMelon\ArrayType\ArrayOfAPIPosting
     */
    public function setAPIPosting(array $aPIPosting = array())
    {
        // validation for constraint: array
        if ('' !== ($aPIPostingArrayErrorMessage = self::validateAPIPostingForArrayConstraintsFromSetAPIPosting($aPIPosting))) {
            throw new \InvalidArgumentException($aPIPostingArrayErrorMessage, __LINE__);
        }
        if (is_null($aPIPosting) || (is_array($aPIPosting) && empty($aPIPosting))) {
            unset($this->APIPosting);
        } else {
            $this->APIPosting = $aPIPosting;
        }
        return $this;
    }
    /**
     * Add item to APIPosting value
     * @throws \InvalidArgumentException
     * @param \RecruitCrm\LogicMelon\StructType\APIPosting $item
     * @return \RecruitCrm\LogicMelon\ArrayType\ArrayOfAPIPosting
     */
    public function addToAPIPosting(\RecruitCrm\LogicMelon\StructType\APIPosting $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \RecruitCrm\LogicMelon\StructType\APIPosting) {
            throw new \InvalidArgumentException(sprintf('The APIPosting property can only contain items of type \RecruitCrm\LogicMelon\StructType\APIPosting, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->APIPosting[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \RecruitCrm\LogicMelon\StructType\APIPosting|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \RecruitCrm\LogicMelon\StructType\APIPosting|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \RecruitCrm\LogicMelon\StructType\APIPosting|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \RecruitCrm\LogicMelon\StructType\APIPosting|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \RecruitCrm\LogicMelon\StructType\APIPosting|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string APIPosting
     */
    public function getAttributeName()
    {
        return 'APIPosting';
    }
}
