<?php

namespace RecruitCrm\LogicMelon\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueryLocations StructType
 * @subpackage Structs
 */
class QueryLocations extends AbstractStructBase
{
    /**
     * The sCultureID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sCultureID;
    /**
     * The sAPIKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sAPIKey;
    /**
     * The q
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $q;
    /**
     * The prefix
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $prefix;
    /**
     * The priority
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $priority;
    /**
     * The LocationValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LocationValue;
    /**
     * Constructor method for QueryLocations
     * @uses QueryLocations::setSCultureID()
     * @uses QueryLocations::setSAPIKey()
     * @uses QueryLocations::setQ()
     * @uses QueryLocations::setPrefix()
     * @uses QueryLocations::setPriority()
     * @uses QueryLocations::setLocationValue()
     * @param string $sCultureID
     * @param string $sAPIKey
     * @param string $q
     * @param string $prefix
     * @param string $priority
     * @param string $locationValue
     */
    public function __construct($sCultureID = null, $sAPIKey = null, $q = null, $prefix = null, $priority = null, $locationValue = null)
    {
        $this
            ->setSCultureID($sCultureID)
            ->setSAPIKey($sAPIKey)
            ->setQ($q)
            ->setPrefix($prefix)
            ->setPriority($priority)
            ->setLocationValue($locationValue);
    }
    /**
     * Get sCultureID value
     * @return string|null
     */
    public function getSCultureID()
    {
        return $this->sCultureID;
    }
    /**
     * Set sCultureID value
     * @param string $sCultureID
     * @return \RecruitCrm\LogicMelon\StructType\QueryLocations
     */
    public function setSCultureID($sCultureID = null)
    {
        // validation for constraint: string
        if (!is_null($sCultureID) && !is_string($sCultureID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sCultureID, true), gettype($sCultureID)), __LINE__);
        }
        $this->sCultureID = $sCultureID;
        return $this;
    }
    /**
     * Get sAPIKey value
     * @return string|null
     */
    public function getSAPIKey()
    {
        return $this->sAPIKey;
    }
    /**
     * Set sAPIKey value
     * @param string $sAPIKey
     * @return \RecruitCrm\LogicMelon\StructType\QueryLocations
     */
    public function setSAPIKey($sAPIKey = null)
    {
        // validation for constraint: string
        if (!is_null($sAPIKey) && !is_string($sAPIKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sAPIKey, true), gettype($sAPIKey)), __LINE__);
        }
        $this->sAPIKey = $sAPIKey;
        return $this;
    }
    /**
     * Get q value
     * @return string|null
     */
    public function getQ()
    {
        return $this->q;
    }
    /**
     * Set q value
     * @param string $q
     * @return \RecruitCrm\LogicMelon\StructType\QueryLocations
     */
    public function setQ($q = null)
    {
        // validation for constraint: string
        if (!is_null($q) && !is_string($q)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($q, true), gettype($q)), __LINE__);
        }
        $this->q = $q;
        return $this;
    }
    /**
     * Get prefix value
     * @return string|null
     */
    public function getPrefix()
    {
        return $this->prefix;
    }
    /**
     * Set prefix value
     * @param string $prefix
     * @return \RecruitCrm\LogicMelon\StructType\QueryLocations
     */
    public function setPrefix($prefix = null)
    {
        // validation for constraint: string
        if (!is_null($prefix) && !is_string($prefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prefix, true), gettype($prefix)), __LINE__);
        }
        $this->prefix = $prefix;
        return $this;
    }
    /**
     * Get priority value
     * @return string|null
     */
    public function getPriority()
    {
        return $this->priority;
    }
    /**
     * Set priority value
     * @param string $priority
     * @return \RecruitCrm\LogicMelon\StructType\QueryLocations
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: string
        if (!is_null($priority) && !is_string($priority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        $this->priority = $priority;
        return $this;
    }
    /**
     * Get LocationValue value
     * @return string|null
     */
    public function getLocationValue()
    {
        return $this->LocationValue;
    }
    /**
     * Set LocationValue value
     * @param string $locationValue
     * @return \RecruitCrm\LogicMelon\StructType\QueryLocations
     */
    public function setLocationValue($locationValue = null)
    {
        // validation for constraint: string
        if (!is_null($locationValue) && !is_string($locationValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locationValue, true), gettype($locationValue)), __LINE__);
        }
        $this->LocationValue = $locationValue;
        return $this;
    }
}
