<?php

namespace RecruitCrm\LogicMelon\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAPIAdvert ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfAPIAdvert
 * @subpackage Arrays
 */
class ArrayOfAPIAdvert extends AbstractStructArrayBase
{
    /**
     * The APIAdvert
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \RecruitCrm\LogicMelon\StructType\APIAdvert[]
     */
    public $APIAdvert;
    /**
     * Constructor method for ArrayOfAPIAdvert
     * @uses ArrayOfAPIAdvert::setAPIAdvert()
     * @param \RecruitCrm\LogicMelon\StructType\APIAdvert[] $aPIAdvert
     */
    public function __construct(array $aPIAdvert = array())
    {
        $this
            ->setAPIAdvert($aPIAdvert);
    }
    /**
     * Get APIAdvert value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert[]|null
     */
    public function getAPIAdvert()
    {
        return isset($this->APIAdvert) ? $this->APIAdvert : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAPIAdvert method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAPIAdvert method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAPIAdvertForArrayConstraintsFromSetAPIAdvert(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfAPIAdvertAPIAdvertItem) {
            // validation for constraint: itemType
            if (!$arrayOfAPIAdvertAPIAdvertItem instanceof \RecruitCrm\LogicMelon\StructType\APIAdvert) {
                $invalidValues[] = is_object($arrayOfAPIAdvertAPIAdvertItem) ? get_class($arrayOfAPIAdvertAPIAdvertItem) : sprintf('%s(%s)', gettype($arrayOfAPIAdvertAPIAdvertItem), var_export($arrayOfAPIAdvertAPIAdvertItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The APIAdvert property can only contain items of type \RecruitCrm\LogicMelon\StructType\APIAdvert, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set APIAdvert value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \RecruitCrm\LogicMelon\StructType\APIAdvert[] $aPIAdvert
     * @return \RecruitCrm\LogicMelon\ArrayType\ArrayOfAPIAdvert
     */
    public function setAPIAdvert(array $aPIAdvert = array())
    {
        // validation for constraint: array
        if ('' !== ($aPIAdvertArrayErrorMessage = self::validateAPIAdvertForArrayConstraintsFromSetAPIAdvert($aPIAdvert))) {
            throw new \InvalidArgumentException($aPIAdvertArrayErrorMessage, __LINE__);
        }
        if (is_null($aPIAdvert) || (is_array($aPIAdvert) && empty($aPIAdvert))) {
            unset($this->APIAdvert);
        } else {
            $this->APIAdvert = $aPIAdvert;
        }
        return $this;
    }
    /**
     * Add item to APIAdvert value
     * @throws \InvalidArgumentException
     * @param \RecruitCrm\LogicMelon\StructType\APIAdvert $item
     * @return \RecruitCrm\LogicMelon\ArrayType\ArrayOfAPIAdvert
     */
    public function addToAPIAdvert(\RecruitCrm\LogicMelon\StructType\APIAdvert $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \RecruitCrm\LogicMelon\StructType\APIAdvert) {
            throw new \InvalidArgumentException(sprintf('The APIAdvert property can only contain items of type \RecruitCrm\LogicMelon\StructType\APIAdvert, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->APIAdvert[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string APIAdvert
     */
    public function getAttributeName()
    {
        return 'APIAdvert';
    }
}
