<?php

namespace RecruitCrm\LogicMelon\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Deliver ServiceType
 * @subpackage Services
 */
class Deliver extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DeliverAdvert
     * Meta information extracted from the WSDL
     * - documentation: <a name='DeliverAdvert'></a><p>Validate an existing advert against a supplied set of destinations and mark for delivery if valid.</p><ul><li><strong>Destinations</strong> Required list of job board destinations as either numeric id's
     * or string identifiers.</li><li><strong>FuturePostDateTimeInUtc</strong> An optional Date and Time components in UTC of when to deliver the advert (default is ASAP).</li><li><strong>sAdvertID, sAdvertReference, sAdvertIdentifier</strong> Locate the
     * existing advert data already stored in the database.</li></ul><meta name='viewport' content='width=device-width, initial-scale=1.0' /><style type='text/css'>/* 30 Sep 2019, PJM, api.logicmelon.com css styles*[:slash:]html { font-size: 1em; }@media
     * (max-width: 770px) { html, table {font-size: 150%;margin-left: 0px;}body {margin: 0px;}body div,p,h1,h2,h3,li,ul, table td{margin-left: 0px !important;}html, h1, h2, h3, p {padding: 0px 5px 0px 5px;}h2 {word-break: break-all;}table {width:100%;}table
     * td {display: block;}input[type=text],select,textarea {width:100%;}pre { white-space: pre-wrap; word-wrap: break-word; text-align: left; font-size:120%; }.heading1 {width: 100%;padding: 5px 0px;text-indent:
     * 15px;}#wrap,#header,#navi,#main-top,#col-centre, #col-centre-wide, #col-left, #col-left-wide,.module-left {width:100%;}#main-top{margin-left:5px !important; background:none;}.module-left li { width: 95%; margin: 1px 0px 0px 0px; padding: 0 0 0 10px;
     * }#main-bottom {background:none;}.box-head { background-position-x: 4px; } #content a {display:block;}}</style>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RecruitCrm\LogicMelon\StructType\DeliverAdvert $parameters
     * @return \RecruitCrm\LogicMelon\StructType\DeliverAdvertResponse|bool
     */
    public function DeliverAdvert(\RecruitCrm\LogicMelon\StructType\DeliverAdvert $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeliverAdvert($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \RecruitCrm\LogicMelon\StructType\DeliverAdvertResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
