<?php

namespace RecruitCrm\LogicMelon\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetLoginURLResult StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetLoginURLResult
 * @subpackage Structs
 */
class GetLoginURLResult extends AbstractStructBase
{
    /**
     * The UserID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UserID;
    /**
     * The OrganisationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrganisationID;
    /**
     * The LoginSuccess
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $LoginSuccess;
    /**
     * The RedirectUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RedirectUrl;
    /**
     * The LoginMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoginMessage;
    /**
     * Constructor method for GetLoginURLResult
     * @uses GetLoginURLResult::setUserID()
     * @uses GetLoginURLResult::setOrganisationID()
     * @uses GetLoginURLResult::setLoginSuccess()
     * @uses GetLoginURLResult::setRedirectUrl()
     * @uses GetLoginURLResult::setLoginMessage()
     * @param int $userID
     * @param int $organisationID
     * @param bool $loginSuccess
     * @param string $redirectUrl
     * @param string $loginMessage
     */
    public function __construct($userID = null, $organisationID = null, $loginSuccess = null, $redirectUrl = null, $loginMessage = null)
    {
        $this
            ->setUserID($userID)
            ->setOrganisationID($organisationID)
            ->setLoginSuccess($loginSuccess)
            ->setRedirectUrl($redirectUrl)
            ->setLoginMessage($loginMessage);
    }
    /**
     * Get UserID value
     * @return int
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param int $userID
     * @return \RecruitCrm\LogicMelon\StructType\GetLoginURLResult
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: int
        if (!is_null($userID) && !(is_int($userID) || ctype_digit($userID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($userID, true), gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get OrganisationID value
     * @return int
     */
    public function getOrganisationID()
    {
        return $this->OrganisationID;
    }
    /**
     * Set OrganisationID value
     * @param int $organisationID
     * @return \RecruitCrm\LogicMelon\StructType\GetLoginURLResult
     */
    public function setOrganisationID($organisationID = null)
    {
        // validation for constraint: int
        if (!is_null($organisationID) && !(is_int($organisationID) || ctype_digit($organisationID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($organisationID, true), gettype($organisationID)), __LINE__);
        }
        $this->OrganisationID = $organisationID;
        return $this;
    }
    /**
     * Get LoginSuccess value
     * @return bool
     */
    public function getLoginSuccess()
    {
        return $this->LoginSuccess;
    }
    /**
     * Set LoginSuccess value
     * @param bool $loginSuccess
     * @return \RecruitCrm\LogicMelon\StructType\GetLoginURLResult
     */
    public function setLoginSuccess($loginSuccess = null)
    {
        // validation for constraint: boolean
        if (!is_null($loginSuccess) && !is_bool($loginSuccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($loginSuccess, true), gettype($loginSuccess)), __LINE__);
        }
        $this->LoginSuccess = $loginSuccess;
        return $this;
    }
    /**
     * Get RedirectUrl value
     * @return string|null
     */
    public function getRedirectUrl()
    {
        return $this->RedirectUrl;
    }
    /**
     * Set RedirectUrl value
     * @param string $redirectUrl
     * @return \RecruitCrm\LogicMelon\StructType\GetLoginURLResult
     */
    public function setRedirectUrl($redirectUrl = null)
    {
        // validation for constraint: string
        if (!is_null($redirectUrl) && !is_string($redirectUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($redirectUrl, true), gettype($redirectUrl)), __LINE__);
        }
        $this->RedirectUrl = $redirectUrl;
        return $this;
    }
    /**
     * Get LoginMessage value
     * @return string|null
     */
    public function getLoginMessage()
    {
        return $this->LoginMessage;
    }
    /**
     * Set LoginMessage value
     * @param string $loginMessage
     * @return \RecruitCrm\LogicMelon\StructType\GetLoginURLResult
     */
    public function setLoginMessage($loginMessage = null)
    {
        // validation for constraint: string
        if (!is_null($loginMessage) && !is_string($loginMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginMessage, true), gettype($loginMessage)), __LINE__);
        }
        $this->LoginMessage = $loginMessage;
        return $this;
    }
}
