<?php

namespace RecruitCrm\LogicMelon\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for APIAdvertValue StructType
 * @subpackage Structs
 */
class APIAdvertValue extends AbstractStructBase
{
    /**
     * The AdvertID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AdvertID;
    /**
     * The FeedID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FeedID;
    /**
     * The FieldID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FieldID;
    /**
     * The SchemaIdentifier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SchemaIdentifier;
    /**
     * The FieldIdentifier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FieldIdentifier;
    /**
     * The Values
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1
     */
    public $Values;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Value;
    /**
     * Constructor method for APIAdvertValue
     * @uses APIAdvertValue::setAdvertID()
     * @uses APIAdvertValue::setFeedID()
     * @uses APIAdvertValue::setFieldID()
     * @uses APIAdvertValue::setSchemaIdentifier()
     * @uses APIAdvertValue::setFieldIdentifier()
     * @uses APIAdvertValue::setValues()
     * @uses APIAdvertValue::setValue()
     * @param int $advertID
     * @param int $feedID
     * @param int $fieldID
     * @param string $schemaIdentifier
     * @param string $fieldIdentifier
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1 $values
     * @param string $value
     */
    public function __construct($advertID = null, $feedID = null, $fieldID = null, $schemaIdentifier = null, $fieldIdentifier = null, \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1 $values = null, $value = null)
    {
        $this
            ->setAdvertID($advertID)
            ->setFeedID($feedID)
            ->setFieldID($fieldID)
            ->setSchemaIdentifier($schemaIdentifier)
            ->setFieldIdentifier($fieldIdentifier)
            ->setValues($values)
            ->setValue($value);
    }
    /**
     * Get AdvertID value
     * @return int
     */
    public function getAdvertID()
    {
        return $this->AdvertID;
    }
    /**
     * Set AdvertID value
     * @param int $advertID
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvertValue
     */
    public function setAdvertID($advertID = null)
    {
        // validation for constraint: int
        if (!is_null($advertID) && !(is_int($advertID) || ctype_digit($advertID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($advertID, true), gettype($advertID)), __LINE__);
        }
        $this->AdvertID = $advertID;
        return $this;
    }
    /**
     * Get FeedID value
     * @return int
     */
    public function getFeedID()
    {
        return $this->FeedID;
    }
    /**
     * Set FeedID value
     * @param int $feedID
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvertValue
     */
    public function setFeedID($feedID = null)
    {
        // validation for constraint: int
        if (!is_null($feedID) && !(is_int($feedID) || ctype_digit($feedID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($feedID, true), gettype($feedID)), __LINE__);
        }
        $this->FeedID = $feedID;
        return $this;
    }
    /**
     * Get FieldID value
     * @return int
     */
    public function getFieldID()
    {
        return $this->FieldID;
    }
    /**
     * Set FieldID value
     * @param int $fieldID
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvertValue
     */
    public function setFieldID($fieldID = null)
    {
        // validation for constraint: int
        if (!is_null($fieldID) && !(is_int($fieldID) || ctype_digit($fieldID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fieldID, true), gettype($fieldID)), __LINE__);
        }
        $this->FieldID = $fieldID;
        return $this;
    }
    /**
     * Get SchemaIdentifier value
     * @return string|null
     */
    public function getSchemaIdentifier()
    {
        return $this->SchemaIdentifier;
    }
    /**
     * Set SchemaIdentifier value
     * @param string $schemaIdentifier
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvertValue
     */
    public function setSchemaIdentifier($schemaIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($schemaIdentifier) && !is_string($schemaIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schemaIdentifier, true), gettype($schemaIdentifier)), __LINE__);
        }
        $this->SchemaIdentifier = $schemaIdentifier;
        return $this;
    }
    /**
     * Get FieldIdentifier value
     * @return string|null
     */
    public function getFieldIdentifier()
    {
        return $this->FieldIdentifier;
    }
    /**
     * Set FieldIdentifier value
     * @param string $fieldIdentifier
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvertValue
     */
    public function setFieldIdentifier($fieldIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($fieldIdentifier) && !is_string($fieldIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fieldIdentifier, true), gettype($fieldIdentifier)), __LINE__);
        }
        $this->FieldIdentifier = $fieldIdentifier;
        return $this;
    }
    /**
     * Get Values value
     * @return \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1|null
     */
    public function getValues()
    {
        return $this->Values;
    }
    /**
     * Set Values value
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1 $values
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvertValue
     */
    public function setValues(\RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1 $values = null)
    {
        $this->Values = $values;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvertValue
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
}
