<?php

namespace RecruitCrm\LogicMelon\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidateFieldResult StructType
 * @subpackage Structs
 */
class ValidateFieldResult extends AbstractStructBase
{
    /**
     * The FieldID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FieldID;
    /**
     * The Valid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Valid;
    /**
     * The FieldIdentifier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FieldIdentifier;
    /**
     * The FieldLabel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FieldLabel;
    /**
     * The FieldComments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FieldComments;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comments;
    /**
     * The CultureID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CultureID;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Value;
    /**
     * The Values
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1
     */
    public $Values;
    /**
     * Constructor method for ValidateFieldResult
     * @uses ValidateFieldResult::setFieldID()
     * @uses ValidateFieldResult::setValid()
     * @uses ValidateFieldResult::setFieldIdentifier()
     * @uses ValidateFieldResult::setFieldLabel()
     * @uses ValidateFieldResult::setFieldComments()
     * @uses ValidateFieldResult::setComments()
     * @uses ValidateFieldResult::setCultureID()
     * @uses ValidateFieldResult::setMessage()
     * @uses ValidateFieldResult::setValue()
     * @uses ValidateFieldResult::setValues()
     * @param int $fieldID
     * @param bool $valid
     * @param string $fieldIdentifier
     * @param string $fieldLabel
     * @param string $fieldComments
     * @param string $comments
     * @param string $cultureID
     * @param string $message
     * @param string $value
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1 $values
     */
    public function __construct($fieldID = null, $valid = null, $fieldIdentifier = null, $fieldLabel = null, $fieldComments = null, $comments = null, $cultureID = null, $message = null, $value = null, \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1 $values = null)
    {
        $this
            ->setFieldID($fieldID)
            ->setValid($valid)
            ->setFieldIdentifier($fieldIdentifier)
            ->setFieldLabel($fieldLabel)
            ->setFieldComments($fieldComments)
            ->setComments($comments)
            ->setCultureID($cultureID)
            ->setMessage($message)
            ->setValue($value)
            ->setValues($values);
    }
    /**
     * Get FieldID value
     * @return int
     */
    public function getFieldID()
    {
        return $this->FieldID;
    }
    /**
     * Set FieldID value
     * @param int $fieldID
     * @return \RecruitCrm\LogicMelon\StructType\ValidateFieldResult
     */
    public function setFieldID($fieldID = null)
    {
        // validation for constraint: int
        if (!is_null($fieldID) && !(is_int($fieldID) || ctype_digit($fieldID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fieldID, true), gettype($fieldID)), __LINE__);
        }
        $this->FieldID = $fieldID;
        return $this;
    }
    /**
     * Get Valid value
     * @return bool
     */
    public function getValid()
    {
        return $this->Valid;
    }
    /**
     * Set Valid value
     * @param bool $valid
     * @return \RecruitCrm\LogicMelon\StructType\ValidateFieldResult
     */
    public function setValid($valid = null)
    {
        // validation for constraint: boolean
        if (!is_null($valid) && !is_bool($valid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($valid, true), gettype($valid)), __LINE__);
        }
        $this->Valid = $valid;
        return $this;
    }
    /**
     * Get FieldIdentifier value
     * @return string|null
     */
    public function getFieldIdentifier()
    {
        return $this->FieldIdentifier;
    }
    /**
     * Set FieldIdentifier value
     * @param string $fieldIdentifier
     * @return \RecruitCrm\LogicMelon\StructType\ValidateFieldResult
     */
    public function setFieldIdentifier($fieldIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($fieldIdentifier) && !is_string($fieldIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fieldIdentifier, true), gettype($fieldIdentifier)), __LINE__);
        }
        $this->FieldIdentifier = $fieldIdentifier;
        return $this;
    }
    /**
     * Get FieldLabel value
     * @return string|null
     */
    public function getFieldLabel()
    {
        return $this->FieldLabel;
    }
    /**
     * Set FieldLabel value
     * @param string $fieldLabel
     * @return \RecruitCrm\LogicMelon\StructType\ValidateFieldResult
     */
    public function setFieldLabel($fieldLabel = null)
    {
        // validation for constraint: string
        if (!is_null($fieldLabel) && !is_string($fieldLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fieldLabel, true), gettype($fieldLabel)), __LINE__);
        }
        $this->FieldLabel = $fieldLabel;
        return $this;
    }
    /**
     * Get FieldComments value
     * @return string|null
     */
    public function getFieldComments()
    {
        return $this->FieldComments;
    }
    /**
     * Set FieldComments value
     * @param string $fieldComments
     * @return \RecruitCrm\LogicMelon\StructType\ValidateFieldResult
     */
    public function setFieldComments($fieldComments = null)
    {
        // validation for constraint: string
        if (!is_null($fieldComments) && !is_string($fieldComments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fieldComments, true), gettype($fieldComments)), __LINE__);
        }
        $this->FieldComments = $fieldComments;
        return $this;
    }
    /**
     * Get Comments value
     * @return string|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param string $comments
     * @return \RecruitCrm\LogicMelon\StructType\ValidateFieldResult
     */
    public function setComments($comments = null)
    {
        // validation for constraint: string
        if (!is_null($comments) && !is_string($comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comments, true), gettype($comments)), __LINE__);
        }
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get CultureID value
     * @return string|null
     */
    public function getCultureID()
    {
        return $this->CultureID;
    }
    /**
     * Set CultureID value
     * @param string $cultureID
     * @return \RecruitCrm\LogicMelon\StructType\ValidateFieldResult
     */
    public function setCultureID($cultureID = null)
    {
        // validation for constraint: string
        if (!is_null($cultureID) && !is_string($cultureID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cultureID, true), gettype($cultureID)), __LINE__);
        }
        $this->CultureID = $cultureID;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \RecruitCrm\LogicMelon\StructType\ValidateFieldResult
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \RecruitCrm\LogicMelon\StructType\ValidateFieldResult
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get Values value
     * @return \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1|null
     */
    public function getValues()
    {
        return $this->Values;
    }
    /**
     * Set Values value
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1 $values
     * @return \RecruitCrm\LogicMelon\StructType\ValidateFieldResult
     */
    public function setValues(\RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1 $values = null)
    {
        $this->Values = $values;
        return $this;
    }
}
