<?php

namespace RecruitCrm\LogicMelon\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetApplicationsWithFiltersPaged StructType
 * @subpackage Structs
 */
class GetApplicationsWithFiltersPaged extends AbstractStructBase
{
    /**
     * The ApplicationStartDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ApplicationStartDateTime;
    /**
     * The ApplicationEndDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ApplicationEndDateTime;
    /**
     * The bIncludeEmailBody
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $bIncludeEmailBody;
    /**
     * The bIncludeAttachment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $bIncludeAttachment;
    /**
     * The bIncludeParsed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $bIncludeParsed;
    /**
     * The bIncludeEmail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $bIncludeEmail;
    /**
     * The LastScoreDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $LastScoreDate;
    /**
     * The LastProgressDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $LastProgressDate;
    /**
     * The CurrentPage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CurrentPage;
    /**
     * The RowsPerPage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RowsPerPage;
    /**
     * The sCultureID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sCultureID;
    /**
     * The sAPIKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sAPIKey;
    /**
     * The sUsername
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sUsername;
    /**
     * The sUserIdentifier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sUserIdentifier;
    /**
     * The sStartOrganisation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sStartOrganisation;
    /**
     * The sAdvertIdentifier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sAdvertIdentifier;
    /**
     * The sAdvertReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sAdvertReference;
    /**
     * The sAdvertID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sAdvertID;
    /**
     * The Destinations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1
     */
    public $Destinations;
    /**
     * The Ranking
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1
     */
    public $Ranking;
    /**
     * The ProgressID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1
     */
    public $ProgressID;
    /**
     * The AdvertCandidateID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1
     */
    public $AdvertCandidateID;
    /**
     * The Filters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \RecruitCrm\LogicMelon\ArrayType\ArrayOfNameValueFilter
     */
    public $Filters;
    /**
     * The OrderBy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderBy;
    /**
     * Constructor method for GetApplicationsWithFiltersPaged
     * @uses GetApplicationsWithFiltersPaged::setApplicationStartDateTime()
     * @uses GetApplicationsWithFiltersPaged::setApplicationEndDateTime()
     * @uses GetApplicationsWithFiltersPaged::setBIncludeEmailBody()
     * @uses GetApplicationsWithFiltersPaged::setBIncludeAttachment()
     * @uses GetApplicationsWithFiltersPaged::setBIncludeParsed()
     * @uses GetApplicationsWithFiltersPaged::setBIncludeEmail()
     * @uses GetApplicationsWithFiltersPaged::setLastScoreDate()
     * @uses GetApplicationsWithFiltersPaged::setLastProgressDate()
     * @uses GetApplicationsWithFiltersPaged::setCurrentPage()
     * @uses GetApplicationsWithFiltersPaged::setRowsPerPage()
     * @uses GetApplicationsWithFiltersPaged::setSCultureID()
     * @uses GetApplicationsWithFiltersPaged::setSAPIKey()
     * @uses GetApplicationsWithFiltersPaged::setSUsername()
     * @uses GetApplicationsWithFiltersPaged::setSUserIdentifier()
     * @uses GetApplicationsWithFiltersPaged::setSStartOrganisation()
     * @uses GetApplicationsWithFiltersPaged::setSAdvertIdentifier()
     * @uses GetApplicationsWithFiltersPaged::setSAdvertReference()
     * @uses GetApplicationsWithFiltersPaged::setSAdvertID()
     * @uses GetApplicationsWithFiltersPaged::setDestinations()
     * @uses GetApplicationsWithFiltersPaged::setRanking()
     * @uses GetApplicationsWithFiltersPaged::setProgressID()
     * @uses GetApplicationsWithFiltersPaged::setAdvertCandidateID()
     * @uses GetApplicationsWithFiltersPaged::setFilters()
     * @uses GetApplicationsWithFiltersPaged::setOrderBy()
     * @param string $applicationStartDateTime
     * @param string $applicationEndDateTime
     * @param bool $bIncludeEmailBody
     * @param bool $bIncludeAttachment
     * @param bool $bIncludeParsed
     * @param bool $bIncludeEmail
     * @param string $lastScoreDate
     * @param string $lastProgressDate
     * @param int $currentPage
     * @param int $rowsPerPage
     * @param string $sCultureID
     * @param string $sAPIKey
     * @param string $sUsername
     * @param string $sUserIdentifier
     * @param string $sStartOrganisation
     * @param string $sAdvertIdentifier
     * @param string $sAdvertReference
     * @param string $sAdvertID
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1 $destinations
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1 $ranking
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1 $progressID
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1 $advertCandidateID
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfNameValueFilter $filters
     * @param string $orderBy
     */
    public function __construct($applicationStartDateTime = null, $applicationEndDateTime = null, $bIncludeEmailBody = null, $bIncludeAttachment = null, $bIncludeParsed = null, $bIncludeEmail = null, $lastScoreDate = null, $lastProgressDate = null, $currentPage = null, $rowsPerPage = null, $sCultureID = null, $sAPIKey = null, $sUsername = null, $sUserIdentifier = null, $sStartOrganisation = null, $sAdvertIdentifier = null, $sAdvertReference = null, $sAdvertID = null, \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1 $destinations = null, \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1 $ranking = null, \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1 $progressID = null, \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1 $advertCandidateID = null, \RecruitCrm\LogicMelon\ArrayType\ArrayOfNameValueFilter $filters = null, $orderBy = null)
    {
        $this
            ->setApplicationStartDateTime($applicationStartDateTime)
            ->setApplicationEndDateTime($applicationEndDateTime)
            ->setBIncludeEmailBody($bIncludeEmailBody)
            ->setBIncludeAttachment($bIncludeAttachment)
            ->setBIncludeParsed($bIncludeParsed)
            ->setBIncludeEmail($bIncludeEmail)
            ->setLastScoreDate($lastScoreDate)
            ->setLastProgressDate($lastProgressDate)
            ->setCurrentPage($currentPage)
            ->setRowsPerPage($rowsPerPage)
            ->setSCultureID($sCultureID)
            ->setSAPIKey($sAPIKey)
            ->setSUsername($sUsername)
            ->setSUserIdentifier($sUserIdentifier)
            ->setSStartOrganisation($sStartOrganisation)
            ->setSAdvertIdentifier($sAdvertIdentifier)
            ->setSAdvertReference($sAdvertReference)
            ->setSAdvertID($sAdvertID)
            ->setDestinations($destinations)
            ->setRanking($ranking)
            ->setProgressID($progressID)
            ->setAdvertCandidateID($advertCandidateID)
            ->setFilters($filters)
            ->setOrderBy($orderBy);
    }
    /**
     * Get ApplicationStartDateTime value
     * @return string
     */
    public function getApplicationStartDateTime()
    {
        return $this->ApplicationStartDateTime;
    }
    /**
     * Set ApplicationStartDateTime value
     * @param string $applicationStartDateTime
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsWithFiltersPaged
     */
    public function setApplicationStartDateTime($applicationStartDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($applicationStartDateTime) && !is_string($applicationStartDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationStartDateTime, true), gettype($applicationStartDateTime)), __LINE__);
        }
        $this->ApplicationStartDateTime = $applicationStartDateTime;
        return $this;
    }
    /**
     * Get ApplicationEndDateTime value
     * @return string
     */
    public function getApplicationEndDateTime()
    {
        return $this->ApplicationEndDateTime;
    }
    /**
     * Set ApplicationEndDateTime value
     * @param string $applicationEndDateTime
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsWithFiltersPaged
     */
    public function setApplicationEndDateTime($applicationEndDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($applicationEndDateTime) && !is_string($applicationEndDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationEndDateTime, true), gettype($applicationEndDateTime)), __LINE__);
        }
        $this->ApplicationEndDateTime = $applicationEndDateTime;
        return $this;
    }
    /**
     * Get bIncludeEmailBody value
     * @return bool
     */
    public function getBIncludeEmailBody()
    {
        return $this->bIncludeEmailBody;
    }
    /**
     * Set bIncludeEmailBody value
     * @param bool $bIncludeEmailBody
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsWithFiltersPaged
     */
    public function setBIncludeEmailBody($bIncludeEmailBody = null)
    {
        // validation for constraint: boolean
        if (!is_null($bIncludeEmailBody) && !is_bool($bIncludeEmailBody)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bIncludeEmailBody, true), gettype($bIncludeEmailBody)), __LINE__);
        }
        $this->bIncludeEmailBody = $bIncludeEmailBody;
        return $this;
    }
    /**
     * Get bIncludeAttachment value
     * @return bool
     */
    public function getBIncludeAttachment()
    {
        return $this->bIncludeAttachment;
    }
    /**
     * Set bIncludeAttachment value
     * @param bool $bIncludeAttachment
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsWithFiltersPaged
     */
    public function setBIncludeAttachment($bIncludeAttachment = null)
    {
        // validation for constraint: boolean
        if (!is_null($bIncludeAttachment) && !is_bool($bIncludeAttachment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bIncludeAttachment, true), gettype($bIncludeAttachment)), __LINE__);
        }
        $this->bIncludeAttachment = $bIncludeAttachment;
        return $this;
    }
    /**
     * Get bIncludeParsed value
     * @return bool
     */
    public function getBIncludeParsed()
    {
        return $this->bIncludeParsed;
    }
    /**
     * Set bIncludeParsed value
     * @param bool $bIncludeParsed
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsWithFiltersPaged
     */
    public function setBIncludeParsed($bIncludeParsed = null)
    {
        // validation for constraint: boolean
        if (!is_null($bIncludeParsed) && !is_bool($bIncludeParsed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bIncludeParsed, true), gettype($bIncludeParsed)), __LINE__);
        }
        $this->bIncludeParsed = $bIncludeParsed;
        return $this;
    }
    /**
     * Get bIncludeEmail value
     * @return bool
     */
    public function getBIncludeEmail()
    {
        return $this->bIncludeEmail;
    }
    /**
     * Set bIncludeEmail value
     * @param bool $bIncludeEmail
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsWithFiltersPaged
     */
    public function setBIncludeEmail($bIncludeEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($bIncludeEmail) && !is_bool($bIncludeEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bIncludeEmail, true), gettype($bIncludeEmail)), __LINE__);
        }
        $this->bIncludeEmail = $bIncludeEmail;
        return $this;
    }
    /**
     * Get LastScoreDate value
     * @return string
     */
    public function getLastScoreDate()
    {
        return $this->LastScoreDate;
    }
    /**
     * Set LastScoreDate value
     * @param string $lastScoreDate
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsWithFiltersPaged
     */
    public function setLastScoreDate($lastScoreDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastScoreDate) && !is_string($lastScoreDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastScoreDate, true), gettype($lastScoreDate)), __LINE__);
        }
        $this->LastScoreDate = $lastScoreDate;
        return $this;
    }
    /**
     * Get LastProgressDate value
     * @return string
     */
    public function getLastProgressDate()
    {
        return $this->LastProgressDate;
    }
    /**
     * Set LastProgressDate value
     * @param string $lastProgressDate
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsWithFiltersPaged
     */
    public function setLastProgressDate($lastProgressDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastProgressDate) && !is_string($lastProgressDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastProgressDate, true), gettype($lastProgressDate)), __LINE__);
        }
        $this->LastProgressDate = $lastProgressDate;
        return $this;
    }
    /**
     * Get CurrentPage value
     * @return int
     */
    public function getCurrentPage()
    {
        return $this->CurrentPage;
    }
    /**
     * Set CurrentPage value
     * @param int $currentPage
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsWithFiltersPaged
     */
    public function setCurrentPage($currentPage = null)
    {
        // validation for constraint: int
        if (!is_null($currentPage) && !(is_int($currentPage) || ctype_digit($currentPage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($currentPage, true), gettype($currentPage)), __LINE__);
        }
        $this->CurrentPage = $currentPage;
        return $this;
    }
    /**
     * Get RowsPerPage value
     * @return int
     */
    public function getRowsPerPage()
    {
        return $this->RowsPerPage;
    }
    /**
     * Set RowsPerPage value
     * @param int $rowsPerPage
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsWithFiltersPaged
     */
    public function setRowsPerPage($rowsPerPage = null)
    {
        // validation for constraint: int
        if (!is_null($rowsPerPage) && !(is_int($rowsPerPage) || ctype_digit($rowsPerPage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rowsPerPage, true), gettype($rowsPerPage)), __LINE__);
        }
        $this->RowsPerPage = $rowsPerPage;
        return $this;
    }
    /**
     * Get sCultureID value
     * @return string|null
     */
    public function getSCultureID()
    {
        return $this->sCultureID;
    }
    /**
     * Set sCultureID value
     * @param string $sCultureID
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsWithFiltersPaged
     */
    public function setSCultureID($sCultureID = null)
    {
        // validation for constraint: string
        if (!is_null($sCultureID) && !is_string($sCultureID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sCultureID, true), gettype($sCultureID)), __LINE__);
        }
        $this->sCultureID = $sCultureID;
        return $this;
    }
    /**
     * Get sAPIKey value
     * @return string|null
     */
    public function getSAPIKey()
    {
        return $this->sAPIKey;
    }
    /**
     * Set sAPIKey value
     * @param string $sAPIKey
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsWithFiltersPaged
     */
    public function setSAPIKey($sAPIKey = null)
    {
        // validation for constraint: string
        if (!is_null($sAPIKey) && !is_string($sAPIKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sAPIKey, true), gettype($sAPIKey)), __LINE__);
        }
        $this->sAPIKey = $sAPIKey;
        return $this;
    }
    /**
     * Get sUsername value
     * @return string|null
     */
    public function getSUsername()
    {
        return $this->sUsername;
    }
    /**
     * Set sUsername value
     * @param string $sUsername
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsWithFiltersPaged
     */
    public function setSUsername($sUsername = null)
    {
        // validation for constraint: string
        if (!is_null($sUsername) && !is_string($sUsername)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sUsername, true), gettype($sUsername)), __LINE__);
        }
        $this->sUsername = $sUsername;
        return $this;
    }
    /**
     * Get sUserIdentifier value
     * @return string|null
     */
    public function getSUserIdentifier()
    {
        return $this->sUserIdentifier;
    }
    /**
     * Set sUserIdentifier value
     * @param string $sUserIdentifier
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsWithFiltersPaged
     */
    public function setSUserIdentifier($sUserIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($sUserIdentifier) && !is_string($sUserIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sUserIdentifier, true), gettype($sUserIdentifier)), __LINE__);
        }
        $this->sUserIdentifier = $sUserIdentifier;
        return $this;
    }
    /**
     * Get sStartOrganisation value
     * @return string|null
     */
    public function getSStartOrganisation()
    {
        return $this->sStartOrganisation;
    }
    /**
     * Set sStartOrganisation value
     * @param string $sStartOrganisation
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsWithFiltersPaged
     */
    public function setSStartOrganisation($sStartOrganisation = null)
    {
        // validation for constraint: string
        if (!is_null($sStartOrganisation) && !is_string($sStartOrganisation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sStartOrganisation, true), gettype($sStartOrganisation)), __LINE__);
        }
        $this->sStartOrganisation = $sStartOrganisation;
        return $this;
    }
    /**
     * Get sAdvertIdentifier value
     * @return string|null
     */
    public function getSAdvertIdentifier()
    {
        return $this->sAdvertIdentifier;
    }
    /**
     * Set sAdvertIdentifier value
     * @param string $sAdvertIdentifier
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsWithFiltersPaged
     */
    public function setSAdvertIdentifier($sAdvertIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($sAdvertIdentifier) && !is_string($sAdvertIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sAdvertIdentifier, true), gettype($sAdvertIdentifier)), __LINE__);
        }
        $this->sAdvertIdentifier = $sAdvertIdentifier;
        return $this;
    }
    /**
     * Get sAdvertReference value
     * @return string|null
     */
    public function getSAdvertReference()
    {
        return $this->sAdvertReference;
    }
    /**
     * Set sAdvertReference value
     * @param string $sAdvertReference
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsWithFiltersPaged
     */
    public function setSAdvertReference($sAdvertReference = null)
    {
        // validation for constraint: string
        if (!is_null($sAdvertReference) && !is_string($sAdvertReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sAdvertReference, true), gettype($sAdvertReference)), __LINE__);
        }
        $this->sAdvertReference = $sAdvertReference;
        return $this;
    }
    /**
     * Get sAdvertID value
     * @return string|null
     */
    public function getSAdvertID()
    {
        return $this->sAdvertID;
    }
    /**
     * Set sAdvertID value
     * @param string $sAdvertID
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsWithFiltersPaged
     */
    public function setSAdvertID($sAdvertID = null)
    {
        // validation for constraint: string
        if (!is_null($sAdvertID) && !is_string($sAdvertID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sAdvertID, true), gettype($sAdvertID)), __LINE__);
        }
        $this->sAdvertID = $sAdvertID;
        return $this;
    }
    /**
     * Get Destinations value
     * @return \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1|null
     */
    public function getDestinations()
    {
        return $this->Destinations;
    }
    /**
     * Set Destinations value
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1 $destinations
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsWithFiltersPaged
     */
    public function setDestinations(\RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1 $destinations = null)
    {
        $this->Destinations = $destinations;
        return $this;
    }
    /**
     * Get Ranking value
     * @return \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1|null
     */
    public function getRanking()
    {
        return $this->Ranking;
    }
    /**
     * Set Ranking value
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1 $ranking
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsWithFiltersPaged
     */
    public function setRanking(\RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1 $ranking = null)
    {
        $this->Ranking = $ranking;
        return $this;
    }
    /**
     * Get ProgressID value
     * @return \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1|null
     */
    public function getProgressID()
    {
        return $this->ProgressID;
    }
    /**
     * Set ProgressID value
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1 $progressID
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsWithFiltersPaged
     */
    public function setProgressID(\RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1 $progressID = null)
    {
        $this->ProgressID = $progressID;
        return $this;
    }
    /**
     * Get AdvertCandidateID value
     * @return \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1|null
     */
    public function getAdvertCandidateID()
    {
        return $this->AdvertCandidateID;
    }
    /**
     * Set AdvertCandidateID value
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1 $advertCandidateID
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsWithFiltersPaged
     */
    public function setAdvertCandidateID(\RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1 $advertCandidateID = null)
    {
        $this->AdvertCandidateID = $advertCandidateID;
        return $this;
    }
    /**
     * Get Filters value
     * @return \RecruitCrm\LogicMelon\ArrayType\ArrayOfNameValueFilter|null
     */
    public function getFilters()
    {
        return $this->Filters;
    }
    /**
     * Set Filters value
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfNameValueFilter $filters
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsWithFiltersPaged
     */
    public function setFilters(\RecruitCrm\LogicMelon\ArrayType\ArrayOfNameValueFilter $filters = null)
    {
        $this->Filters = $filters;
        return $this;
    }
    /**
     * Get OrderBy value
     * @return string|null
     */
    public function getOrderBy()
    {
        return $this->OrderBy;
    }
    /**
     * Set OrderBy value
     * @param string $orderBy
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsWithFiltersPaged
     */
    public function setOrderBy($orderBy = null)
    {
        // validation for constraint: string
        if (!is_null($orderBy) && !is_string($orderBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderBy, true), gettype($orderBy)), __LINE__);
        }
        $this->OrderBy = $orderBy;
        return $this;
    }
}
