<?php

namespace RecruitCrm\LogicMelon\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAdvertWithValuesWithFiltersPaged StructType
 * @subpackage Structs
 */
class GetAdvertWithValuesWithFiltersPaged extends AbstractStructBase
{
    /**
     * The CurrentPage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CurrentPage;
    /**
     * The RowsPerPage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RowsPerPage;
    /**
     * The sCultureID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sCultureID;
    /**
     * The sAPIKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sAPIKey;
    /**
     * The sUsername
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sUsername;
    /**
     * The sUserIdentifier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sUserIdentifier;
    /**
     * The sStartOrganisation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sStartOrganisation;
    /**
     * The sAdvertIdentifier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sAdvertIdentifier;
    /**
     * The sAdvertReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sAdvertReference;
    /**
     * The sAdvertID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sAdvertID;
    /**
     * The sSearchDays
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sSearchDays;
    /**
     * The FieldIDs
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1
     */
    public $FieldIDs;
    /**
     * The Destinations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1
     */
    public $Destinations;
    /**
     * The Filters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \RecruitCrm\LogicMelon\ArrayType\ArrayOfNameValueFilter
     */
    public $Filters;
    /**
     * The sAdvertStatusIDs
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sAdvertStatusIDs;
    /**
     * The sHideFutureJobs
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sHideFutureJobs;
    /**
     * The sLastScoreDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sLastScoreDate;
    /**
     * The sLastProgressDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sLastProgressDate;
    /**
     * The OrderBy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderBy;
    /**
     * Constructor method for GetAdvertWithValuesWithFiltersPaged
     * @uses GetAdvertWithValuesWithFiltersPaged::setCurrentPage()
     * @uses GetAdvertWithValuesWithFiltersPaged::setRowsPerPage()
     * @uses GetAdvertWithValuesWithFiltersPaged::setSCultureID()
     * @uses GetAdvertWithValuesWithFiltersPaged::setSAPIKey()
     * @uses GetAdvertWithValuesWithFiltersPaged::setSUsername()
     * @uses GetAdvertWithValuesWithFiltersPaged::setSUserIdentifier()
     * @uses GetAdvertWithValuesWithFiltersPaged::setSStartOrganisation()
     * @uses GetAdvertWithValuesWithFiltersPaged::setSAdvertIdentifier()
     * @uses GetAdvertWithValuesWithFiltersPaged::setSAdvertReference()
     * @uses GetAdvertWithValuesWithFiltersPaged::setSAdvertID()
     * @uses GetAdvertWithValuesWithFiltersPaged::setSSearchDays()
     * @uses GetAdvertWithValuesWithFiltersPaged::setFieldIDs()
     * @uses GetAdvertWithValuesWithFiltersPaged::setDestinations()
     * @uses GetAdvertWithValuesWithFiltersPaged::setFilters()
     * @uses GetAdvertWithValuesWithFiltersPaged::setSAdvertStatusIDs()
     * @uses GetAdvertWithValuesWithFiltersPaged::setSHideFutureJobs()
     * @uses GetAdvertWithValuesWithFiltersPaged::setSLastScoreDate()
     * @uses GetAdvertWithValuesWithFiltersPaged::setSLastProgressDate()
     * @uses GetAdvertWithValuesWithFiltersPaged::setOrderBy()
     * @param int $currentPage
     * @param int $rowsPerPage
     * @param string $sCultureID
     * @param string $sAPIKey
     * @param string $sUsername
     * @param string $sUserIdentifier
     * @param string $sStartOrganisation
     * @param string $sAdvertIdentifier
     * @param string $sAdvertReference
     * @param string $sAdvertID
     * @param string $sSearchDays
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1 $fieldIDs
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1 $destinations
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfNameValueFilter $filters
     * @param string $sAdvertStatusIDs
     * @param string $sHideFutureJobs
     * @param string $sLastScoreDate
     * @param string $sLastProgressDate
     * @param string $orderBy
     */
    public function __construct($currentPage = null, $rowsPerPage = null, $sCultureID = null, $sAPIKey = null, $sUsername = null, $sUserIdentifier = null, $sStartOrganisation = null, $sAdvertIdentifier = null, $sAdvertReference = null, $sAdvertID = null, $sSearchDays = null, \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1 $fieldIDs = null, \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1 $destinations = null, \RecruitCrm\LogicMelon\ArrayType\ArrayOfNameValueFilter $filters = null, $sAdvertStatusIDs = null, $sHideFutureJobs = null, $sLastScoreDate = null, $sLastProgressDate = null, $orderBy = null)
    {
        $this
            ->setCurrentPage($currentPage)
            ->setRowsPerPage($rowsPerPage)
            ->setSCultureID($sCultureID)
            ->setSAPIKey($sAPIKey)
            ->setSUsername($sUsername)
            ->setSUserIdentifier($sUserIdentifier)
            ->setSStartOrganisation($sStartOrganisation)
            ->setSAdvertIdentifier($sAdvertIdentifier)
            ->setSAdvertReference($sAdvertReference)
            ->setSAdvertID($sAdvertID)
            ->setSSearchDays($sSearchDays)
            ->setFieldIDs($fieldIDs)
            ->setDestinations($destinations)
            ->setFilters($filters)
            ->setSAdvertStatusIDs($sAdvertStatusIDs)
            ->setSHideFutureJobs($sHideFutureJobs)
            ->setSLastScoreDate($sLastScoreDate)
            ->setSLastProgressDate($sLastProgressDate)
            ->setOrderBy($orderBy);
    }
    /**
     * Get CurrentPage value
     * @return int
     */
    public function getCurrentPage()
    {
        return $this->CurrentPage;
    }
    /**
     * Set CurrentPage value
     * @param int $currentPage
     * @return \RecruitCrm\LogicMelon\StructType\GetAdvertWithValuesWithFiltersPaged
     */
    public function setCurrentPage($currentPage = null)
    {
        // validation for constraint: int
        if (!is_null($currentPage) && !(is_int($currentPage) || ctype_digit($currentPage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($currentPage, true), gettype($currentPage)), __LINE__);
        }
        $this->CurrentPage = $currentPage;
        return $this;
    }
    /**
     * Get RowsPerPage value
     * @return int
     */
    public function getRowsPerPage()
    {
        return $this->RowsPerPage;
    }
    /**
     * Set RowsPerPage value
     * @param int $rowsPerPage
     * @return \RecruitCrm\LogicMelon\StructType\GetAdvertWithValuesWithFiltersPaged
     */
    public function setRowsPerPage($rowsPerPage = null)
    {
        // validation for constraint: int
        if (!is_null($rowsPerPage) && !(is_int($rowsPerPage) || ctype_digit($rowsPerPage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rowsPerPage, true), gettype($rowsPerPage)), __LINE__);
        }
        $this->RowsPerPage = $rowsPerPage;
        return $this;
    }
    /**
     * Get sCultureID value
     * @return string|null
     */
    public function getSCultureID()
    {
        return $this->sCultureID;
    }
    /**
     * Set sCultureID value
     * @param string $sCultureID
     * @return \RecruitCrm\LogicMelon\StructType\GetAdvertWithValuesWithFiltersPaged
     */
    public function setSCultureID($sCultureID = null)
    {
        // validation for constraint: string
        if (!is_null($sCultureID) && !is_string($sCultureID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sCultureID, true), gettype($sCultureID)), __LINE__);
        }
        $this->sCultureID = $sCultureID;
        return $this;
    }
    /**
     * Get sAPIKey value
     * @return string|null
     */
    public function getSAPIKey()
    {
        return $this->sAPIKey;
    }
    /**
     * Set sAPIKey value
     * @param string $sAPIKey
     * @return \RecruitCrm\LogicMelon\StructType\GetAdvertWithValuesWithFiltersPaged
     */
    public function setSAPIKey($sAPIKey = null)
    {
        // validation for constraint: string
        if (!is_null($sAPIKey) && !is_string($sAPIKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sAPIKey, true), gettype($sAPIKey)), __LINE__);
        }
        $this->sAPIKey = $sAPIKey;
        return $this;
    }
    /**
     * Get sUsername value
     * @return string|null
     */
    public function getSUsername()
    {
        return $this->sUsername;
    }
    /**
     * Set sUsername value
     * @param string $sUsername
     * @return \RecruitCrm\LogicMelon\StructType\GetAdvertWithValuesWithFiltersPaged
     */
    public function setSUsername($sUsername = null)
    {
        // validation for constraint: string
        if (!is_null($sUsername) && !is_string($sUsername)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sUsername, true), gettype($sUsername)), __LINE__);
        }
        $this->sUsername = $sUsername;
        return $this;
    }
    /**
     * Get sUserIdentifier value
     * @return string|null
     */
    public function getSUserIdentifier()
    {
        return $this->sUserIdentifier;
    }
    /**
     * Set sUserIdentifier value
     * @param string $sUserIdentifier
     * @return \RecruitCrm\LogicMelon\StructType\GetAdvertWithValuesWithFiltersPaged
     */
    public function setSUserIdentifier($sUserIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($sUserIdentifier) && !is_string($sUserIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sUserIdentifier, true), gettype($sUserIdentifier)), __LINE__);
        }
        $this->sUserIdentifier = $sUserIdentifier;
        return $this;
    }
    /**
     * Get sStartOrganisation value
     * @return string|null
     */
    public function getSStartOrganisation()
    {
        return $this->sStartOrganisation;
    }
    /**
     * Set sStartOrganisation value
     * @param string $sStartOrganisation
     * @return \RecruitCrm\LogicMelon\StructType\GetAdvertWithValuesWithFiltersPaged
     */
    public function setSStartOrganisation($sStartOrganisation = null)
    {
        // validation for constraint: string
        if (!is_null($sStartOrganisation) && !is_string($sStartOrganisation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sStartOrganisation, true), gettype($sStartOrganisation)), __LINE__);
        }
        $this->sStartOrganisation = $sStartOrganisation;
        return $this;
    }
    /**
     * Get sAdvertIdentifier value
     * @return string|null
     */
    public function getSAdvertIdentifier()
    {
        return $this->sAdvertIdentifier;
    }
    /**
     * Set sAdvertIdentifier value
     * @param string $sAdvertIdentifier
     * @return \RecruitCrm\LogicMelon\StructType\GetAdvertWithValuesWithFiltersPaged
     */
    public function setSAdvertIdentifier($sAdvertIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($sAdvertIdentifier) && !is_string($sAdvertIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sAdvertIdentifier, true), gettype($sAdvertIdentifier)), __LINE__);
        }
        $this->sAdvertIdentifier = $sAdvertIdentifier;
        return $this;
    }
    /**
     * Get sAdvertReference value
     * @return string|null
     */
    public function getSAdvertReference()
    {
        return $this->sAdvertReference;
    }
    /**
     * Set sAdvertReference value
     * @param string $sAdvertReference
     * @return \RecruitCrm\LogicMelon\StructType\GetAdvertWithValuesWithFiltersPaged
     */
    public function setSAdvertReference($sAdvertReference = null)
    {
        // validation for constraint: string
        if (!is_null($sAdvertReference) && !is_string($sAdvertReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sAdvertReference, true), gettype($sAdvertReference)), __LINE__);
        }
        $this->sAdvertReference = $sAdvertReference;
        return $this;
    }
    /**
     * Get sAdvertID value
     * @return string|null
     */
    public function getSAdvertID()
    {
        return $this->sAdvertID;
    }
    /**
     * Set sAdvertID value
     * @param string $sAdvertID
     * @return \RecruitCrm\LogicMelon\StructType\GetAdvertWithValuesWithFiltersPaged
     */
    public function setSAdvertID($sAdvertID = null)
    {
        // validation for constraint: string
        if (!is_null($sAdvertID) && !is_string($sAdvertID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sAdvertID, true), gettype($sAdvertID)), __LINE__);
        }
        $this->sAdvertID = $sAdvertID;
        return $this;
    }
    /**
     * Get sSearchDays value
     * @return string|null
     */
    public function getSSearchDays()
    {
        return $this->sSearchDays;
    }
    /**
     * Set sSearchDays value
     * @param string $sSearchDays
     * @return \RecruitCrm\LogicMelon\StructType\GetAdvertWithValuesWithFiltersPaged
     */
    public function setSSearchDays($sSearchDays = null)
    {
        // validation for constraint: string
        if (!is_null($sSearchDays) && !is_string($sSearchDays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sSearchDays, true), gettype($sSearchDays)), __LINE__);
        }
        $this->sSearchDays = $sSearchDays;
        return $this;
    }
    /**
     * Get FieldIDs value
     * @return \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1|null
     */
    public function getFieldIDs()
    {
        return $this->FieldIDs;
    }
    /**
     * Set FieldIDs value
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1 $fieldIDs
     * @return \RecruitCrm\LogicMelon\StructType\GetAdvertWithValuesWithFiltersPaged
     */
    public function setFieldIDs(\RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1 $fieldIDs = null)
    {
        $this->FieldIDs = $fieldIDs;
        return $this;
    }
    /**
     * Get Destinations value
     * @return \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1|null
     */
    public function getDestinations()
    {
        return $this->Destinations;
    }
    /**
     * Set Destinations value
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1 $destinations
     * @return \RecruitCrm\LogicMelon\StructType\GetAdvertWithValuesWithFiltersPaged
     */
    public function setDestinations(\RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1 $destinations = null)
    {
        $this->Destinations = $destinations;
        return $this;
    }
    /**
     * Get Filters value
     * @return \RecruitCrm\LogicMelon\ArrayType\ArrayOfNameValueFilter|null
     */
    public function getFilters()
    {
        return $this->Filters;
    }
    /**
     * Set Filters value
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfNameValueFilter $filters
     * @return \RecruitCrm\LogicMelon\StructType\GetAdvertWithValuesWithFiltersPaged
     */
    public function setFilters(\RecruitCrm\LogicMelon\ArrayType\ArrayOfNameValueFilter $filters = null)
    {
        $this->Filters = $filters;
        return $this;
    }
    /**
     * Get sAdvertStatusIDs value
     * @return string|null
     */
    public function getSAdvertStatusIDs()
    {
        return $this->sAdvertStatusIDs;
    }
    /**
     * Set sAdvertStatusIDs value
     * @param string $sAdvertStatusIDs
     * @return \RecruitCrm\LogicMelon\StructType\GetAdvertWithValuesWithFiltersPaged
     */
    public function setSAdvertStatusIDs($sAdvertStatusIDs = null)
    {
        // validation for constraint: string
        if (!is_null($sAdvertStatusIDs) && !is_string($sAdvertStatusIDs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sAdvertStatusIDs, true), gettype($sAdvertStatusIDs)), __LINE__);
        }
        $this->sAdvertStatusIDs = $sAdvertStatusIDs;
        return $this;
    }
    /**
     * Get sHideFutureJobs value
     * @return string|null
     */
    public function getSHideFutureJobs()
    {
        return $this->sHideFutureJobs;
    }
    /**
     * Set sHideFutureJobs value
     * @param string $sHideFutureJobs
     * @return \RecruitCrm\LogicMelon\StructType\GetAdvertWithValuesWithFiltersPaged
     */
    public function setSHideFutureJobs($sHideFutureJobs = null)
    {
        // validation for constraint: string
        if (!is_null($sHideFutureJobs) && !is_string($sHideFutureJobs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sHideFutureJobs, true), gettype($sHideFutureJobs)), __LINE__);
        }
        $this->sHideFutureJobs = $sHideFutureJobs;
        return $this;
    }
    /**
     * Get sLastScoreDate value
     * @return string|null
     */
    public function getSLastScoreDate()
    {
        return $this->sLastScoreDate;
    }
    /**
     * Set sLastScoreDate value
     * @param string $sLastScoreDate
     * @return \RecruitCrm\LogicMelon\StructType\GetAdvertWithValuesWithFiltersPaged
     */
    public function setSLastScoreDate($sLastScoreDate = null)
    {
        // validation for constraint: string
        if (!is_null($sLastScoreDate) && !is_string($sLastScoreDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sLastScoreDate, true), gettype($sLastScoreDate)), __LINE__);
        }
        $this->sLastScoreDate = $sLastScoreDate;
        return $this;
    }
    /**
     * Get sLastProgressDate value
     * @return string|null
     */
    public function getSLastProgressDate()
    {
        return $this->sLastProgressDate;
    }
    /**
     * Set sLastProgressDate value
     * @param string $sLastProgressDate
     * @return \RecruitCrm\LogicMelon\StructType\GetAdvertWithValuesWithFiltersPaged
     */
    public function setSLastProgressDate($sLastProgressDate = null)
    {
        // validation for constraint: string
        if (!is_null($sLastProgressDate) && !is_string($sLastProgressDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sLastProgressDate, true), gettype($sLastProgressDate)), __LINE__);
        }
        $this->sLastProgressDate = $sLastProgressDate;
        return $this;
    }
    /**
     * Get OrderBy value
     * @return string|null
     */
    public function getOrderBy()
    {
        return $this->OrderBy;
    }
    /**
     * Set OrderBy value
     * @param string $orderBy
     * @return \RecruitCrm\LogicMelon\StructType\GetAdvertWithValuesWithFiltersPaged
     */
    public function setOrderBy($orderBy = null)
    {
        // validation for constraint: string
        if (!is_null($orderBy) && !is_string($orderBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderBy, true), gettype($orderBy)), __LINE__);
        }
        $this->OrderBy = $orderBy;
        return $this;
    }
}
